function y = beta(z,w,v)
%BETA   Beta function.
%   Y = BETA(Z,W) computes the beta function for corresponding
%   elements of Z and W.  The beta function is defined as
%
%   beta(z,w) = integral from 0 to 1 of t.^(z-1) .* (1-t).^(w-1) dt.
%
%   The arrays Z and W must be the same size (or either can be
%   scalar).
%
%   See also BETAINC, BETALN.

%   C. Moler, 2-1-91.
%   Ref: Abramowitz & Stegun, sec. 6.2.
%   Copyright (c) 1984-97 by The MathWorks, Inc.
%   $Revision: 5.4 $  $Date: 1997/04/08 06:41:28 $

  if nargin<2
     error("Not enough input arguments.");
  elseif nargin == 2
     y = exp(gammaln(z)+gammaln(w)-gammaln(z+w));
  elseif nargin == 3
     y = betainc(z,w,v);
  end
end
