function y = chi2pdf(x,v)
%CHI2PDF Chi-square probability density function (pdf).
%   Y = CHI2PDF(X,V) returns the chi-square pdf with V degrees  
%   of freedom at the values in X. The chi-square pdf with V 
%   degrees of freedom, is the gamma pdf with parameters V/2 and 2.
%
%   The size of Y is the common size of X and V. A scalar input   
%   functions as a constant matrix of the same size as the other input.    

%   References:
%      [1]  L. Devroye, "Non-Uniform Random Variate Generation", 
%      Springer-Verlag, 1986, pages 402-403.

%   Copyright (c) 1993-96 by The MathWorks, Inc.
%   $Revision: 2.4 $  $Date: 1996/02/21 18:34:00 $

if nargin < 2 
    error("Requires two input arguments."); 
end

[errorcode x v] = distchck(2,x,v);

if errorcode > 0
    error("Requires non-scalar arguments to match in size.");
end

% Initialize Y to zero.
y=zeros(size(x));

y = gampdf(x,v/2,2);

% Return NaN if the degrees of freedom is not a positive integer.
k = find(v <= 0  |  round(v) ~= v);
if any(k)
    y(k) = NaN;
end

end
