function y = erf(x)
%ERF Error function.
%   Y = ERF(X) is the error function for each element of X.  X must be
%   real. The error function is defined as:
%
%     erf(x) = 2/sqrt(pi) * integral from 0 to x of exp(-t^2) dt.
%
%   See also ERFC, ERFCX, ERFINV.

%   Ref: Abramowitz & Stegun, Handbook of Mathemtical Functions, sec. 7.1.

%   Copyright (c) 1984-97 by The MathWorks, Inc.
%   $Revision: 5.7 $  $Date: 1997/04/08 06:42:16 $

% Derived from a FORTRAN program by W. J. Cody.
% See ERFCORE.

%if ~isreal(x), error('X must be real.'); end
siz = size(x);
x = x(:);
y = erfcore(x,0);
y = reshape(y,siz);
end
