function y = erfc(x)
%ERFC  Complementary error function.
%   Y = ERFC(X) is the complementary error function for each element
%   of X.  X must be real.  The complementary error function is
%   defined as:
%
%     erfc(x) = 2/sqrt(pi) * integral from x to inf of exp(-t^2) dt.
%             = 1 - erf(x).
%
%   See also ERF, ERFCX, ERFINV.

%   Ref: Abramowitz & Stegun, Handbook of Mathemtical Functions, sec. 7.1.
%   Copyright (c) 1984-97 by The MathWorks, Inc.
%   $Revision: 5.6 $  $Date: 1997/04/08 06:42:22 $

% Derived from a FORTRAN program by W. J. Cody.


y = erfcore(x,1);
end