function bin2mul(vars,prefix,options,value,nonvalue) 
%value je vrednost Da odgovora
	if def(vars)
		vars=ucase(vars);
		if size(vars,1)<size(vars,2)
			vars = vars';
		end
	else
		error("Nije specificiran 'vars' argument")
	end
	if def(prefix)
		prefix=ucase(prefix);
	else
		error("Nije specificiran 'prefix' argument")
	end
	rewrite = 0;
	opt = "rewrite"; 
	if def(options); 
		options = lcase(options);
		for i=1:max(size(options))
			j = strlen(options(i));
			if j
				if (left(opt,j)==options(i))
					rewrite = 1;
				end
			end
		end
	end
	if def(value)
		if isstr(value)
			value = str2num(value(1));
		end
	else
		value = 1;
	end
	if def(nonvalue)
		if isstr(nonvalue)
			nonvalue = str2num(nonvalue(1));
		end
	else
		nonvalue = NaN;
	end
	
	x = Data(:,vars)==value;
	val1 = max(rsum(x));
	newvars = make(val1,1,"");
	ivars = max(size(vars));
	
	if val1
		%check for existance of variables in data set
		greska = 0;
		for i=1:val1
			newvar = strcat(prefix,num2str("%d",i));
			if strlen(newvar)>8
				printf("Predugacko ime za varijablu - %s; probajte sa kracim prefixom\n", newvar);
				greska = 1;
			end
			if ext(newvar)
				if ~rewrite
					printf("Varijabla %s postoji u fajlu\n", newvar);
					greska = 1;
				end
			else
				DataAddVar(newvar);
			end
			newvars(i) = newvar;
		end	
		if greska
			error ("Varijable postoje u fajlu, a niste naveli REWRITE opciju, ili je PREFIX predugacak!");
		end
		vallab = GetVarLabel(vars);
		indx = find(~strlen(vallab));
		if indx~=[]
			vallab(indx) = vars(indx);
		end
		[varlab, vallab] = TitleRowLab(vallab);
		if varlab~=""
			SetVarLabel(newvars,varlab);
			SetNumLabel(newvars,1:ivars,vallab);
		end
		
		xn = size(x,1);
		xmul = make(xn,val1,NaN);
		for i=1:xn
			indx = find(x(i,:))';
			if indx~=[]
				xmul(i,1:size(indx,2)) = indx;
			end
		end
		if nonvalue==NaN
			sivars = sprintf("%d",ivars);
			nonvalue = 10^strlen(sivars) - 1;
			if nonvalue<=ivars
				nonvalue = 10^(strlen(sivars)+1) - 1;
			end
		end
		indx = find(xmul(:,1)==NaN);
		if indx~=[]
			xmul(indx,1)=nonvalue;
			SetNumLabel(newvars,nonvalue,"None");
		end
		Data(:,newvars) = xmul;
		printf("Kal successfully created %d new variables!\n",size(xmul,2));
		DataSave
	end
end