function jtable(vars,type, col1, col2, col3, brkat, color, decimal, ltperc, srtvl, value, label, filter, chart, options, missing, select, boxes, footer, valid_values, wave)
%options = ascending descending sysmis nozerocolumns nototal ownbase
%     - kod averages i binary da se pravi naslov, to vec ima samo implementrati
%     - napraviti da moze da se bira ukrstanje u grafikonu
%     - da se ne ispisuju svi redovi u grafikonima, vec oni znacajni
%     - da moze da se imaju uvek iste boje u grafikonima
%     - da moze i da se ima share, ovo staviti u BIGTAB
%     - da moze da se radi sa trimovanim MEANOVIMA, isto u BIGTAB
%     - da moze da se ispisuje wgh N, a da se reskallira na velicinu uzorak, to je zbog veceg pondera isto u BIGTAB
%     - napraviti block multiple
%     - Decimale gleda i na N, a treba samo na vrednosti iz C
%     - nonzerocolumns - to tek treba napraviti, samo je stavljeno u opcije ali nema koda
%     - nozerocolumns u marks neradi
%     - filter u taboffreq, ni missing neradi
%TODO - napraviti da moze rezultat u tabeli bude kolicnik tj % sume dve varijable (npr. sume broja simova i sume broja radnika u firmi)



	if def(type) & size(type,1)
		type=lcase(type(1));
	else
		type="simple";
	end

	if def(vars)   
		vars=ucase(vars);
		vars = resolveSet(vars);
	else
		error("Argument 'vars' is not specified")
	end

	colt = 0;
	global g_col1,g_col2,g_col3;
	for cj=1:15
		if def(col#cj)
			i = 0;
		elseif cj<4 & size(g_col#cj,1)
		  col#cj = g_col#cj;
		else
			col#cj = [];
		end

		if size(col#cj,1)==0
			col#cj="";
		else
			if colt<cj-1;error("Argument 'col"+num2str("%d",cj-1)+"' is not specified");end
			col#cj=resolveSet(ucase(col#cj));
			colt = colt+1;
		end
	end

	global g_boxes
	if def(boxes)
		m = max(size(boxes));
		if mod(m,4)
			error("Argumnet boxes is not well defined");
		end
		for i=3:m:4
			if boxes(i)~=":"
				error("Argumnet boxes is not well defined");
			end
		end
	elseif size(g_boxes,1)
		boxes = g_boxes;
	else
		boxes = "";
	end

	if def(brkat) & size(brkat,1)
		if isstr(brkat); brkat = str2num(brkat); end
	else
		brkat = 5;
	end

	global gWave
	if def(wave)
		gWave = ucase(wave(1));
	else
		gWave = "WAVE";
	end
	
	global g_color;
	if def(color)
		if size(color,1)==0
			color = 3;
		else
			color = str2num(color);
		end
	elseif g_color~=[]
		color = g_color;
	else
		color = 3;
	end

	global g_decimal;
	defdecimal = 0;
	if def(decimal)
		if max(size(decimal))
			decimal = str2num(decimal);
			if max(size(decimal))>2
				error("Argument 'decimal' can have maximum of 2 parameters")
			elseif max(size(decimal))==1
				decimal = make(1,2,decimal);
			end
			defdecimal = 1;
		else
			decimal = [1 0];
		end
	elseif g_decimal~=[]
		decimal = g_decimal;
	else
		decimal = [1 0];
	end

	global g_chart;
	if def(chart)
		if max(size(chart))
			chart = str2num(chart);
			if max(size(chart))>2
				error("Argument 'chart' can have maximum of 2 parameters")
			end
		else
			if colt
				chart = [1 0];
			else
				chart = 1;
			end
		end
	elseif g_chart~=[]
		chart = g_chart;
	else
		if colt
			chart = [1 0];
		else
			chart = 1;
		end
	end

	global g_ltperc;
	if def(ltperc) & size(ltperc,1)
		ltperc = str2num(ltperc);
		if prod(size(ltperc))~=2
			error("Argument 'ltpers' have to have 2 parameters")
		end
	elseif g_ltperc~=[]
		ltperc = g_ltperc;
	else
		ltperc = [];
	end


	global g_srtvl;
	if def(srtvl) & size(srtvl,1)
		srtvl = srtvl(1);
		srtvl = str2num(srtvl);
	elseif g_srtvl~=[]
		srtvl = g_srtvl;
	else
		srtvl = [];
	end

	global g_value;
	if def(value) & size(value,1)
		value = str2num(value);
	elseif g_value~=[]
		value = g_value;
	else
		value = 1;
	end

	lRF = NaN;
	lDK = NaN;
	tot_lok_mis = [];
	global g_missing;
	if size(g_missing,1)
		lok_mis = g_missing;
		mc_miss;
	end
	if def(missing)
		lok_mis = missing;
		mc_miss;
	end

	labVar = "";
	if def(label) & label(1)~=""
		for i=1:max(size(label))
			labVar = labVar+" "+label(i);
		end
	end

	if ~def(filter);
		if colt
			filter = make(colt,1,"");
		else
			filter = make(1,1,"");
		end
	else
		filter = ucase(filter);
		i = prod(size(filter));
		if i ~= colt
			if colt==0
				filter = make(i,1,filter);
			elseif i==1
				filter = make(colt,1,filter);
			else
				error("Argument 'filter' if defined more than once, has to be designed for each column group");
			end
		end
		k=find(filter=="ALL");
		if k~=[]
			filter(k)=filter_name;
		end
	end

	if def(select)
		if strlen(filter_name)
			filter_old = filter_name;
			DataSelect();
		else
			filter_old = "";
		end
		SEL = calcFilter(select);
		DataSelect(filter_old);
	else
		SEL = [];
	end


	global g_footer;
	if def(footer)
		foot = footer(1);
		for i=2:max(size(footer))
			foot = foot+" "+footer(i);
		end
	elseif size(g_footer,1)
		foot = g_footer;
	else
		foot = "";
	end


	global g_valid_values;
	if def(valid_values) & size(valid_values,1)
		validVals = str2num(valid_values);
	elseif g_valid_values~=[]
		validVals = g_valid_values;
	else
		validVals = 1:brkat;
	end

	opt = [ "ascending"
			"descending"
			"sysmis"
			"nozerocolumns"
			"unwn"
			"non"
			"nobase"
			"samplesize"
			"ownbase"
			"count"
			"share"
			"trim" %12
			"notrim"
			"nototal1"
			"nototal2"
			"nototal3"
			"nototal4"
			"nototal5"
			"nototal6"
			"nototal7"
			"nototal8"
			"top5"
			"transpose"
			"plus"
			"labvals"
			"rlabvals"
			"clabvals"
			"nochart"
			"label_sort"
			"whole"
			"varname"  %31
			"mean"
			"sd"
            "slope"];
	opt_off = "$"+opt;
	sort = 0;
	nototal = zeros(1,15);
	unwn = 0;
	base5 = 1;
	BTopts = "noprint";
	wghn = 1;
	strStats = "colpct";
	trim = 0;
	top5=0;
	transpose=0;
	label_sort = 0;
	sysmis = 0;
	whole = 0;
	varname = 0;
	opt_mean = 0;
	opt_sd = 0;
	jcount = "%";
    jti_slope = 0;
	global g_options;
	if (size(g_options,1))
		if def(options)
			for i=1:max(size(g_options))
				if ~any(options==g_options(i))
					options = [options,g_options(i)];
				end
			end
		else
			options = g_options;
		end
	end

	ko_arr = make(size(opt_off),1);
	if def(options);
		options = lcase(options);
		for i=1:max(size(options))
			j = strlen(options(i));
			ko = find(left(opt_off,j)==(options(i)));
			if max(size(ko))>1
				error("Parametar in OPTIONS is not uniquely defined");
			elseif ko~=[]
				ko_arr(ko)=0;
			end
		end
		for i=1:max(size(options))
			j = strlen(options(i));
			k = find(left(opt,j)==options(i));
			ko = find(left(opt_off,j)==(options(i)));
			if k==[]
				if ko==[]
					error("Unknown parametar in OPTIONS");
				end
			elseif max(size(k))>1
				error("Parametar in OPTIONS is not uniquely defined");
			elseif k==1 & ko_arr(k)
				sort=1;
			elseif k==2 & ko_arr(k)
				sort=-1;
			elseif k==3 & ko_arr(k)
				BTopts = [BTopts,"sysmis"];
				sysmis = 1;
			elseif k==4 & ko_arr(k)
				BTopts = [BTopts,"nozerocolumns"];
			elseif k==5 & ko_arr(k)
				unwn = 1;
			elseif k==6 & ko_arr(k)
				wghn = 0;
			elseif k==7 & ko_arr(k)
				base5 = 0;
			elseif k==8 & ko_arr(k)
				BTopts = [BTopts,"samplesize"];
			elseif k==9 & ko_arr(k)
				BTopts = [BTopts,"ownbase"]; %radi se svaki red posebno, nema jedinstvene baze
				base5 = -1; %bez veze je onda baza, kada je svaka varijabla za sebe
				%wghn = 0;
			elseif k==10  & ko_arr(k)
				strStats = "count";
				jcount = "No";
				if ~defdecimal
					decimal = [0 0];
				end
			elseif k==11  & ko_arr(k)
				strStats = "colshare";
			elseif k==12 & ko_arr(k)
				trim=1;
			elseif k==13 & ko_arr(k)
				trim=0;
			elseif k==14 & ko_arr(k)
				nototal(1)=1;
			elseif k==15 & ko_arr(k)
				nototal(2)=1;
			elseif k==16 & ko_arr(k)
				nototal(3)=1;
			elseif k==17 & ko_arr(k)
				nototal(4)=1;
			elseif k==18 & ko_arr(k)
				nototal(5)=1;
			elseif k==19 & ko_arr(k)
				nototal(6)=1;
			elseif k==20 & ko_arr(k)
				nototal(7)=1;
			elseif k==21 & ko_arr(k)
				nototal(8)=1;
			elseif k==22 & ko_arr(k)
				top5=1;
			elseif k==23 & ko_arr(k)
				transpose=1;
			elseif k==24 & ko_arr(k)
				BTopts = [BTopts,"plus"];
			elseif k==25 & ko_arr(k)
				BTopts = [BTopts,"labvals"];
			elseif k==26 & ko_arr(k)
				BTopts = [BTopts,"rlabvals"];
			elseif k==27 & ko_arr(k)
				BTopts = [BTopts,"clabvals"];
			elseif k==28 & ko_arr(k)
				chart = NaN;
			elseif k==29 & ko_arr(k)
				label_sort = 1;
			elseif k==30 & ko_arr(k)
				BTopts = [BTopts,"whole"];
				whole = 1;
			elseif k==31 & ko_arr(k)
				varname = 1;
			elseif k==32 & ko_arr(k)
				opt_mean = 1;
			elseif k==33 & ko_arr(k)
				opt_sd = 1;
            elseif k==34 & ko_arr(k)
                jti_slope = 1;
			end
		end
	end

	plava   = [RGB( 47, 143,  95), NaN; RGB( 51, 153, 102), NaN; RGB( 216, 240, 223), NaN];
	crvena  = [RGB(239,   0,   0), NaN; RGB(255,   0,   0), NaN; RGB( 255, 189, 222), NaN];
	%boje; %poziva definicije boja u boje.s
	LBColor = [15921906; RGB(192, 192, 192);RGB(  0, 204, 255)]; %svetlija, tamnija
	LFColor = [NaN; NaN;RGB(255, 255, 255)]; %boja fonta svetlija, tamnija

	typestr = ["simple"
	           "multiple"
	           "binary"
	           "marks"
	           "average"
	           "median"];
	j = strlen(type);
	ktype = find(left(typestr,j)==type);
	if ktype==[]
		error("Unknow parametar in TYPE");
	elseif max(size(ktype))>1
		error("Parametar in TYPE is not uniquely defined");
	end

	if ktype==1 | ktype==4
		broj_iteracija = prod(size(vars));
		simple = 1;
	else
		broj_iteracija = 1;
		simple = 0;
	end

	j = 1;
	while j<=broj_iteracija
		ssimple = 0;
		if simple==1
			varijabla = vars(j);
			if left(varijabla,1)=="$"
				ssimple = 0;
			else
				ssimple = 1;
			end
			if j<broj_iteracija & vars(j+1)=="#"
				k = 2;
				while (j+k<=broj_iteracija & vars(j+k)~="#")
					k=k+1;
				end
				if j+k>broj_iteracija
					error("Afer variable '" + vars(j) + "' operator # is not enclosed.")
				end
				varijabla = vars(j:(j+k));
				j = j+k;
			end
		elseif ktype==2
			DataAddMVar("$_POM",vars)
			if labVar ~= ""
				SetVarLabel("$_POM",labVar);
			else
				SetVarLabel("$_POM",GetVarLabel(vars(1)));% + " - MULTIPLE");
			end
			varijabla = "$_POM";
		elseif ktype==3
			DataAddMVar("$_POM",vars,value)
			if labVar ~= ""
				SetVarLabel("$_POM",labVar);
			else
				SetVarLabel("$_POM",GetVarLabel(vars(1)));% + " - MULTIPLE");
			end
			varijabla = "$_POM";
		else
			varijabla = vars;
		end
		j = j+1;
		if def(missing) | size(g_missing,1)
			varss = GetVarName(varijabla);
			[missT, missS] = GetMissVal(varss);
			misT = missT;
			misS = missS;
			if sum(misT<0)
				error("Variable "+varijabla+" has defined 'range' for missing values, which is not supported yet")
			end

			if lNONE==1
				misT = make(size(missT),NaN);
				misS = make(size(missS),NaN);
			end
			if lRF~=NaN
				stableMiss(misS, lRF, RF);
			end
			if lDK~=NaN
				stableMiss(misS, lDK, DK);
			end
			if size(tot_lok_mis,1)
				for i=1:max(size(tot_lok_mis))
					stableMiss(misS, 1, tot_lok_mis(i))
				end
			end
			misT = rsum(misS~=NaN);
			SetMissVal(varss, misT, misS)
		end
		totC = [];
		totRes = [];
		totcGrn = [];
		totcL = ["";""];
		totwghN = [];
		i=0;
		repeat
			i = i+1;
		%for i=1:colt
			ukljuciFilter;
			if (size(Data(:,1),1)==0)
				iskljuciFilter
				return
			end
			if ktype==5 % Average
				if strStats ~= "colshare"
					if trim
						strStats_ = "trimmean";
					else
						strStats_ = "mean";
					end
				else
					if trim
						strStats_ = "trimcolshare";
					else
						strStats_ = "colshare";
					end
				end
				strStats_ = [make(size(varijabla),strStats_);make(size(varijabla),"(");varijabla;make(size(varijabla),")")];
				strStats_ = strStats_(:);
				[C,Res,rL,cL,cGrn,rGrn,rNum,cNum,wghN,unwN] = bigtab_jti("",["$total",col#i],strStats_,"",ltperc,srtvl,BTopts,boxes);
			elseif ktype==6 %median
				strStats_ = [make(size(varijabla),"median");make(size(varijabla),"(");varijabla;make(size(varijabla),")")];
				strStats_ = strStats_(:);
				[C,Res,rL,cL,cGrn,rGrn,rNum,cNum,wghN,unwN] = bigtab_jti("",["$total",col#i],strStats_,"",ltperc,srtvl,BTopts,boxes);
			elseif ktype==4 %marks
				[C,Res,rL,cL,cGrn,rGrn,rNum,cNum,wghN,unwN] = bigtab_jti(varijabla,["$total",col#i],strStats,"",ltperc,srtvl,BTopts,boxes,num2str("%d",brkat), validVals);
			else
				[C,Res,rL,cL,cGrn,rGrn,rNum,cNum,wghN,unwN,waveGr] = bigtab_jti(varijabla,["$total",col#i],strStats,"",ltperc,srtvl,BTopts,boxes);
			end
            
            if jti_slope
                jti  = size(cL,1);
                if outputType
                    cLadd = make(jti, 3, "~");
                else
                    cLadd = make(jti, 3, "");
                end
                cLadd(jti, :) = ["slope","sig","ind"];
                for jti=size(waveGr, 2):1:-1
                    jg = waveGr(1,jti)+waveGr(3,jti)-1;
                    jslope = slope(C(:, waveGr(1,jti):jg)');
                    if jg==size(C,2)
                        %C = [C, zeros(size(C,1), 3)];
                        C = [C, jslope];
                        Res = [Res, zeros(size(Res,1), 3)];
                        wghN = [wghN, zeros(size(wghN,1), 3)];
                        unwN = [unwN, zeros(size(unwN,1), 3)];
                        cNum = [cNum; zeros(3, size(cNum,2))];
                        cL = [cL, cLadd];
                    else
                        %C = [C(:,1:jg),zeros(size(C,1), 3), C(:,(jg+1):NaN)];
                        C = [C(:,1:jg),jslope, C(:,(jg+1):NaN)];
                        Res = [Res(:,1:jg),zeros(size(Res,1), 3), Res(:,(jg+1):NaN)];
                        wghN = [wghN(:,1:jg),zeros(size(wghN,1), 3), wghN(:,(jg+1):NaN)];
                        unwN = [unwN(:,1:jg),zeros(size(unwN,1), 3), unwN(:,(jg+1):NaN)];
                        cNum = [cNum(1:jg);zeros(3, size(cNum,2)); cNum((jg+1):NaN)];
                        cL = [cL(:,1:jg),cLadd, cL(:,(jg+1):NaN)];
                    end
                end
            
                for jti=1:size(waveGr, 2)
                    cj = find(waveGr(1,jti)==cGrn(1,:));
                    if (cj==[])
                        error("ovo nije ok")
                    else
                        cj = cj(prod(size(cj)));
                    end
                    cGrn(:,cj) = cGrn(:,cj)+3*[(jti-1);jti];
                    waveGr(:, jti) = waveGr(:, jti) + 3*[(jti-1);0;1];
                end
            end
            
			if labVar ~= ""
				naslov = labVar;
				if ktype==5 | ktype==6
					rL(:,[1,2])=[];
				else
					rL(:,[1,3])=[];
				end
			else
				naslov = rL(1,1);
				if ktype==3 %binary
					[naslov1,rL] = TitleRowLab(rL(:,2));
					if strlen(naslov1)
						naslov = naslov1;
					end
				elseif ktype==5 | ktype==6
					[naslov1,rL] = TitleRowLab(rL(:,3));
					if strlen(naslov1)
						naslov = naslov1;
					end
				elseif ssimple==0
					naslov = rL(1,1);
					[naslov1,rL] = TitleRowLab(rL(:,2));
					if strlen(naslov1)
						naslov = naslov1;
					end
				else
					rL(:,[1,3])=[];
				end
			end


			sortiranjeC;
			base5N = wghN(1);
			if nototal(i)
				C(:,1)=[];
				Res(:,1)=[];
				cL(:,1)=[];
				cNum(1)=[];
				wghN(1)=[];
				unwN(1)=[];
				cGrn(:,1)=[];
				cGrn = cGrn-1;
                waveGr(1,:)=waveGr(1,:)-1;
			end
			bojaCelija;

			if base5 == -1
				wghN(1) = NaN;
				unwN(1) = NaN;
			end
            
            
            

		%%%%%%%%% pravljenje decimala na C
			if ktype<5
				indx0 = find(C==0 | C==NaN);
			else
				indx0 = find(C==NaN);
			end
            
            
            
			if colt
				strfor = "%0." + num2str("%0.0f", decimal(2)) + "f";
				CS(:,(2- nototal(i)):size(C,2)) = num2str(strfor,C(:,(2- nototal(i)):NaN));
                
                if jti_slope
                    jti_idx = waveGr(1,:)+waveGr(3,:)-1;
                    CS(:,jti_idx-1) = num2str("%0.2f",C(:,jti_idx-1));
                    CS(:,jti_idx-2) = num2str("%0.2f",C(:,jti_idx-2));
                
                    ind = C(:,jti_idx);
                    indS = make(size(ind),"false");
                    indx = find(ind==2);
                    if indx~=[]
                        indS(indx)="true";
                    end
                    CS(:,jti_idx) = indS;
                end
                
				if whole
					CS100((2- nototal(i)):size(C,2)) = num2str(strfor,csum(C(:,(2- nototal(i)):NaN)));
				end
				m1 = 10^decimal(2);
				C(:,(2- nototal(i)):NaN) = round(C(:,(2- nototal(i)):NaN)*m1)/m1;
			end
			if ~nototal(i)
				strfor = "%0." + num2str("%0.0f", decimal(1)) + "f";
				CS(:,1) = num2str(strfor,C(:,1));
				if whole
					CS100(1) = num2str(strfor,csum(C(:,1)));
				end
				m1 = 10^decimal(1);
				C(:,1) = round(C(:,1)*m1)/m1;
			end
			%CS = num2str("%0.1f",C);
            
           
            
			if outputType%>1
				apsC = abs(C);
				indx = find(C<0);
				if any(indx)
					apsC(indx) = apsC(indx)*10;
				end
				m1 = mmax(apsC);
				m2 = strlen(num2str("%0.0f",m1));
				m2 = 10^(m2-1);

				while m2>1
					indx = find(apsC<m2);
					if indx~=[]
						CS(indx)="#"+CS(indx);
					end
					m2 = m2/10;
				end
			end

			if any(indx0)
				CS(indx0)="";
			end
            
           
            
			LinCol = make(1, max(max(cGrn)), NaN); %pravljenje linija
			LinCol(cGrn(2,:)) = 2;                 %za kolone
			LinRow = make(size(rL,1)-1,1,NaN); %Debljina linije za redove, na koje se dodaje gore i dole
			if filter(1)==filter(i) %ovo je bitno jer ako su razliciti filteri stampa se prva tabela
				chartL = rL;
			end

%ovaj deo samo za SIMPLE
			%if strStats == "colshare"
			%	simple=1;
			%end
			simple100=0;
			if ssimple | any(strStats == "colshare")
				if ktype==1
					BojaFS = make(1,size(C,2),NaN);  %Boja Fonta za sig
					if outputType
						sigStr = make(1, size(C,2), jcount);%String za sig
					else
						sigStr = make(1, size(C,2), jcount);%String za sig
					end
					%for k=1:size(cGrn,2)
					%	if cGrn(1,k)~=cGrn(2,k)
					%		chi = msum(Res(:,cGrn(1,k):cGrn(2,k)).^2);
					%		df = (size(Res,1)-1) * (cGrn(2,k)-cGrn(1,k));
					%		chi = 1 - chi2cdf(chi, df);
					%		sigStr(cGrn(1,k)) = num2str("%0.2f",chi);
					%		if chi<=0.05
					%			BojaFS(cGrn(1,k)) = 16777215;%Bela
					%		end
					%	else
					%		sigStr(cGrn(1,k)) = "";
					%	end
					%end
                    if jti_slope
                        sigStr([jti_idx,jti_idx-2,jti_idx-1])="";
                    end
					CS = [sigStr;CS];
					rL = ["";rL];
					LinRow = [2;LinRow];
				end
				%if ~any(strStats == "count")
				%	if whole == 0
				%		if outputType
				%			r100 = make(1, size(CS,2), "~");
				%		else
				%			r100 = make(1, size(CS,2), "");
				%		end
				%		r100(1) = "100%";
				%		CS = [CS;r100];
				%	else
				%		CS = [CS;CS100'];
				%	end
				%	simple100=1;
				%	rL = [rL;"Total"];
				%	LinRow = [LinRow;3];
				%end
			end


			if unwn
				if unwN(1)~=NaN
					CS = [num2str("%0.0f",unwN);CS];
				else
					CS = [make(size(unwN),"-");CS];
				end
				rL = ["N unw";rL];
				LinRow = [2; LinRow];
			end
			if wghn
				if wghN(1)~=NaN
					CS = [CS;num2str("%0.0f",wghN)];
				else
					CS = [CS;make(size(wghN),"-")];
				end
                if jti_slope
                    CS(size(CS,1), [jti_idx,jti_idx-2,jti_idx-1])="";
                end
				rL = [rL;"Base"];
				LinRow = [LinRow;2];
			end

			LinCol = [make(1,size(rL,2),NaN), 2, LinCol];
			LinRow = [make(size(cL,1),1,NaN); LinRow];
			LinRow(1) = 1;

			BojaF = make(size(CS)+[size(cL,1),size(rL,2)],NaN);
			BojaB = BojaF;
			BojaB(1,:) = LBColor(3);                %Tamnije plavo za prvi red
			BojaB(2:size(cL,1)+1,:) = LBColor(2);                %Tamnije plavo za prvi red
			%BojaBC(1,:) = LBColor(2); % ovo je sada za sig tj za jcount oznaku
			BojaF(1,:) = LFColor(3);               %Tamnije plavo za prvi red
			if ktype==4
				simpleM = 0; % ovo je zbog pocetne vrednosti za marks
			else
				simpleM = ssimple;
			end


			%if unwn
			%	BojaBC(size(cL,1),:) = LBColor(2-simpleM); %Svetlije plavo za unwN
			%end
			%if wghn
			%	BojaBC(size(cL,1)+unwn,:) = LBColor(2-simpleM); %Svetlije plavo za N
			%end

			if ssimple | any(strStats == "colshare")
				%if simple100
					BojaB(size(BojaB,1),:) = LBColor(2);     %Tamnije plavo za Base
					BojaF(size(BojaF,1),:) = LFColor(2);
				%end
				%if ktype==1
				%	BojaB(size(cL,1)+1+wghn+unwn,:) = LBColor(2); %Tamnije plavo za Sig
				%	BojaF(size(cL,1)+1+wghn+unwn,size(rL,2)+1:NaN) = BojaFS;
				%end
				%simple = 0; %ovo zbog marks, jer su samo sledece dve linije ugrozene
			end
			BojaB(size(BojaB,1)-size(BojaBC,1):size(BojaB,1)-1,size(rL,2)+1:NaN) = BojaBC;
			BojaF(size(BojaB,1)-size(BojaBC,1):size(BojaB,1)-1,size(rL,2)+1:NaN) = BojaFC;

			LinRow = [NaN;LinRow;NaN];
			if filter(1)==filter(i)
				totC = [totC,C];
				totRes = [totRes,Res];
				if totcGrn ==[]
					totcGrn = cGrn;
				else
					totcGrn = [totcGrn,cGrn+totcGrn(2,size(totcGrn,2))];
				end
				totcL = [totcL,cL(size(cL,1)-1:size(cL,1),:)];
				totwghN = [totwghN,wghN];
			end

			C#i = C;
			cL#i = cL;
			if ktype==4 | opt_mean |opt_sd %pravimo meanse za mark varijantu
				strStats_=[];
				if ktype==4 | opt_mean
					strStats_=[strStats_;make(size(varijabla),"mean");make(size(varijabla),"(");varijabla;make(size(varijabla),")")];
					rL = [rL;"Mean"];
				end
				if opt_sd
					strStats_=[strStats_;make(size(varijabla),"sd");make(size(varijabla),"(");varijabla;make(size(varijabla),")")];
					rL = [rL;"SD"];
				end
				strStats_=strStats_(:);
				[C,Res] = bigtab_jti("",["$total",col#i],strStats_,"",ltperc,srtvl,BTopts,boxes,num2str("%d",brkat), validVals);
				if nototal(i)
					C(:,1)=[];
					Res(:,1)=[];
				end
				bojaCelija;
				CS = [CS;num2str("%0.1f",C)];
				BojaF = [BojaF;[make(size(BojaFC,1),1,NaN),BojaFC]];
				BojaB = [BojaB;[make(size(BojaBC,1),1,NaN),BojaBC]];

				indx = find(rNum==-Inf);
				if any(indx)
					LinRow(size(cL,1)+1+unwn+indx) = 3;
				end
				indx = find(rNum==Inf);
				if any(indx)
					LinRow(size(cL,1)+2+unwn+indx) = 3;
				end
				indx = find(rNum<=brkat);
				if any(indx)
					indx = indx(size(indx,1));
					LinRow(size(cL,1)+2+unwn+indx) = 2;
				end
				LinRow(size(LinRow,1)) = 2;
				LinRow = [LinRow;make(size(BojaFC,1),1,NaN)];
			end



			CS#i = CS;
			rL#i = rL;
			BojaF#i  = BojaF;
			BojaB#i  = BojaB;
			LinRow#i = LinRow;
			LinCol#i = LinCol;
			%rNum#i = rNum;
			%cNum#i = cNum;
			%Res#i = Res;
			%wghN#i = wghN;
			%unwN#i = unwN;
			%cGrn#i = cGrn;rGrn#i = rGrn;

			iskljuciFilter;

			%heading(1,naslov)
			%print(CS,rL,cL,BojaF,BojaB,LinRow,LinCol);
			%print(CS,rL#i,cL#i)
			%print(unwN#i,[],[])
			clear CS
		until (i>=colt);
		if def(missing)
			SetMissVal(varss, missT, missS)
		end
		totcL(:,1)=[]; %brisemo one gluposti sa pocetka
		if (varname)
			naslov = varijabla(1) +" "+naslov;
		end
		chartANDtables;
		if ktype==2 | ktype==3
			DataDelVar(varijabla);
		end
	end
end


macro ukljuciFilter
	if strlen(filter(i)) | SEL~=[]
		if strlen(filter_name)
			filter_old = filter_name;
		else
			filter_old = "";
		end
		DataSelect();
		k = 0;
		repeat
			k = k+1;
			filter_new = "FILT" + num2str("%d",k);
		until (~vext(filter_new))
		DataAddVar(filter_new);
		deleteFil = 1;
		if strlen(filter(i))
			if SEL == []
				Data(:,filter_new) = Data(:,filter_old) & Data(:,filter(i));
			else
				Data(:,filter_new) = Data(:,filter_old) & Data(:,filter(i)) & SEL;
			end
		elseif SEL~=[]
			if strlen(filter_old)
				Data(:,filter_new) = Data(:,filter_old) & SEL;
			else
				Data(:,filter_new) = SEL;
			end
		end
		DataSelect(filter_new);
	end
end

macro iskljuciFilter
	if strlen(filter(i)) | SEL ~= []
		DataSelect(filter_old);
		if deleteFil
			DataDelVar(filter_new);
		end
	end
end

macro bojaCelija
	BojaFC = make(size(C),NaN);      %Boja Fonta za tabelu
	BojaBC = make(size(C),NaN);      %Boja Fonta za celiju

	if color>0
		indx = find(Res>2.58);
		if indx~=[];BojaBC(indx) = plava(1,1);BojaFC(indx) = plava(1,2);end;
		if color>1
			indx = find(Res<=2.58 & Res>1.96);
			if indx~=[];BojaBC(indx) = plava(2,1);BojaFC(indx) = plava(2,2);end;
			if color>2
				indx = find(Res<=1.96 & Res>1.64);
				if indx~=[];BojaBC(indx) = plava(3,1);BojaFC(indx) = plava(3,2);end;
			end
		end
	end

	if color>0
		indx = find(Res<-2.58);
		if indx~=[];BojaBC(indx) = crvena(1,1);BojaFC(indx) = crvena(1,2);end;
		if color>1
			indx = find(Res>=-2.58 & Res<-1.96);
			if indx~=[];BojaBC(indx) = crvena(2,1);BojaFC(indx) = crvena(2,2);end;
			if color>2
				indx = find(Res>=-1.96 & Res<-1.64);
				if indx~=[];BojaBC(indx) = crvena(3,1);BojaFC(indx) = crvena(3,2);end;
			end
		end
	end
end

macro sortiranjeC
	aa  = max(size(rNum));
	vise = 1;
	if (rNum(aa)==NaN)
		vise=2;
	end
	if (sort | label_sort) & size(C,1)>vise
		if (vise==2)
			rLmiss = rL(aa);
			rL(aa)=[];
			Cmiss = C(aa,:);
			C(aa,:) = [];
			Resmiss = Res(aa,:);
			Res(aa,:) = [];
			rNum(aa) = [];
		end
		if label_sort
			rL_lok = rL;
			if sort<0
				[rL indx] = sortd(rL);
			else
				[rL indx] = sorta(rL);
			end
			%for i_=1:size(rL,1)
			%	indx_lok = find(rL_lok==rL(i_));
			%	if max(size(indx_lok))>1
			%		error("Multiple value labels '"+rL(i_)+"' with label_sort option is not alowed");
			%	end
			%	indx(i_) = indx_lok;
			%end
		else
			if srtvl~=[] & (max(size(rNum))~=1)
				indx = find(rNum<srtvl);
				if size(indx,1)>1
					indx = [indx,C(indx,1)];
					if sort<0
						sortd(indx,2);
					else
						sorta(indx,2);
					end
					indxF = indx(:,1);
				else
					indxF = indx;% indxF=[]
				end

				indx = find(rNum>=srtvl);
				if size(indx,1)>1
					indx = [indx,rNum(indx)];
					sorta(indx,2);
					indx = [indxF;indx(:,1)];
				else
					indx = [indxF;indx];
				end
			else
				indx = 1:size(C,1);
				indx = [indx,C(:,1)];
				if size(indx,1)>1
					if sort<0
						sortd(indx,2);
					else
						sorta(indx,2);
					end
				end
				indx = indx(:,1);
			end
			rL = rL(indx,:);
		end
		C = C(indx,:);
		if (max(size(rNum))~=1)
			rNum = rNum(indx,:);
		end
		Res = Res(indx,:);
		if (vise==2)
			rL = [rL;rLmiss];
			C = [C;Cmiss];
			Res = [Res;Resmiss];
			rNum = [rNum;NaN];
		end
	end
end


macro chartANDtables

	heading(3,naslov)

	base5L = "";
	if simple
		if ssimple
			base5L = "";
		else
			if language==1
				base5L = "Multiple answers; ";
			else
				base5L = "VisSestruki odgovori; ";
			end
		end
	elseif ktype==2
		if language==1
			base5L = "Multiple answers; ";
		else
			base5L = "VisSestruki odgovori; ";
		end
	elseif ktype==5
		if any(strStats == "colshare" | strStats == "trimcolshare")
			if language==1
				base5L = "Shares; ";
			else
				base5L = "Procentualna ucHesScCa; ";
			end
		else
			if language==1
				base5L = "Average values; ";
			else
				base5L = "ProsecHne vrednosti; ";
			end
		end
	elseif ktype==6
		if language==1
			base5L = "Median values; ";
		else
			base5L = "Medijane; ";
		end
	end
	baza5(base5,base5L,base5N);

	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% koji grafici
	if outputType==2 & chart(1)~=NaN
		C = num2str("%0.1f",totC);
		rL_n = size(chartL,1);
		srand;
		rlBoje = ZeljeneBoje(rL_n,ktype);
		global IsteBojeLabel, IsteBojeNum
		if def(IsteBojeLabel) & size(IsteBojeLabel,1)
			for i=1:rL_n
				indx = find(IsteBojeLabel==chartL(i));
				if any(indx)
					indx = indx(1);
					rlBoje(i) = IsteBojeNum(indx);
				end
			end
		end

		if any(chart>max(size(totcGrn)))
			error("Specifed Dara variable for charting is not defined, number is out of range")
		end
		Res = totRes;
		Res = Res.^2;
		cramRow = make(size(Res,1),size(totcGrn,2),NaN);
		for i=1:size(totcGrn,2)
			cramRow(:,i) = rsum(Res(:,totcGrn(1,i):totcGrn(2,i)))./msum(totwghN(totcGrn(1,i):totcGrn(2,i)));
		end
		cramRow = cramRow./(cmin([(totcGrn(2,:)-totcGrn(1,:)+1);make([1,size(cramRow,2)],rL_n)])-make([1,size(cramRow,2)],1));

		Res = csum(Res);
		cramCol = make(1,size(totcGrn,2),0);
		for i=1:size(totcGrn,2)
			cramCol(i) = sum(Res(totcGrn(1,i):totcGrn(2,i)))/msum(totwghN(totcGrn(1,i):totcGrn(2,i)));
		end

		cramCol = sqrt(cramCol./(cmin([(totcGrn(2,:)-totcGrn(1,:)+1);make(size(cramCol),rL_n)])-make([1,size(cramRow,2)],1)));
		indx = find(cramCol==NaN | cramCol==Inf);
		if indx~=[]
			cramCol(indx) = 0;
		end
		if size(chart,2)==1 %samo jedan graf
			indx2 = 0;
			if chart==0
				if sum(cramCol>0.2) %crtamo 2 grafika posto ima vecih ukstanja
					indx = find(cramCol==max(cramCol));
					indx1 = indx(1);
				else
					indx1 = 1;
				end
			else
				indx1 = chart;
			end
		else %dva grafa
			cramCol = [cramCol',(1:size(cramCol,2))];
			if size(cramCol,1)>1
				sortd(cramCol,1);
			end
			indx = find(cramCol(:,1)<0.2);
			if any(indx)
				cramCol(indx,:)=[];
			end
			if sum(chart)==0
				if size(cramCol,1)>1
					indx1 = cramCol(1,2);
					indx2 = cramCol(2,2);
				elseif size(cramCol,1)>0
					indx1 = 1;
					indx2 = cramCol(1,2);
				else
					indx1 = 1;
					indx2 = 0;
				end
				%if sum(cramCol>0.2)
				%	indx = find(cramCol==max(cramCol));
				%	indx2 = indx(1);
				%else
				%	indx2 = 0;
				%end
			elseif chart(1)==0
				if size(cramCol,1)
					indx = find(cramCol(:,2)==chart(2));
					if any(indx)
						cramCol(indx,:)=[];
					end
					if size(cramCol,1)
						indx1 = cramCol(1,2);
						indx2 = chart(2);
					else
						indx1 = chart(2);
						indx2 = 0;
					end
				else
					indx1 = chart(2);
					indx2 = 0;
				end
			elseif chart(2)==0
				if size(cramCol,1)
					indx = find(cramCol(:,2)==chart(1));
					if any(indx)
						cramCol(indx,:)=[];
					end
					if size(cramCol,1)
						indx1 = chart(1);
						indx2 = cramCol(1,2);
					else
						indx1 = chart(1);
						indx2 = 0;
					end
				else
					indx1 = chart(1);
					indx2 = 0;
				end
			else
				indx1 = chart(1);
				indx2 = chart(2);
			end
		end



		if (ktype==5 & any(strStats ~= "colshare")) | ktype==6 %ovo je average pa mu treba
			sp = "";
		else
			sp = "%";
		end

		indx1 = totcGrn(1,indx1):totcGrn(2,indx1);
		if indx2
			if rL_n>4
				if top5
					indy2 = 1:5;
				else
					cramRow = [cramRow(:,indx2),(1:rL_n)];
					if size(cramRow,1)>1
						sortd(cramRow);
					end
					indy2 = cramRow(1:4,2);
				end
			else
				indy2 = [];
			end
			indx2 = totcGrn(1,indx2):totcGrn(2,indx2);
			%u indx su one kolone koje treba izabrati

			if rL_n<=5
				if colt<=1
					if (ktype==1 | ktype ==4) & max(size(indx1))==1
						lchartPie(C,chartL, totcL, [], indx1, rlBoje, [250,350],sp);
					else
						lchartBar(C,chartL, totcL, [], indx1, rlBoje, [250,350],sp);
					end
					rchartBar(C,chartL, totcL, indy2, indx2, rlBoje, [250,350],sp);
				elseif colt==2
					if (ktype==1 | ktype ==4) & max(size(indx1))==1
						lchartPie(C,chartL, totcL, [], indx1, rlBoje, [180,350],sp);
					else
						lchartBar(C,chartL, totcL, [], indx1, rlBoje, [180,350],sp);
					end
					rchartBar(C,chartL, totcL, indy2, indx2, rlBoje, [180,350],sp);
				else
					if (ktype==1 | ktype ==4) & max(size(indx1))==1
						lchartPie(C,chartL, totcL, [], indx1, rlBoje, [260,350],sp);
					else
						lchartBar(C,chartL, totcL, [], indx1, rlBoje, [260,350],sp);
					end
					rchartBar(C,chartL, totcL, indy2, indx2, rlBoje, [260,350],sp);
					heading(4,naslov);
					baza5(base5,base5L,base5N);
				end
			elseif rL_n<=10
				if colt<=1
					lchartBar(C,chartL, totcL, [],    indx1, rlBoje, [250,350],sp);
					rchartBar(C,chartL, totcL, indy2, indx2, rlBoje, [250,350],sp);
				else
					lchartBar(C,chartL, totcL, [],    indx1, rlBoje, [350,350],sp);
					rchartBar(C,chartL, totcL, indy2, indx2, rlBoje, [350,350],sp);
					heading(4,naslov);
					baza5(base5,base5L,base5N);
				end
			elseif rL_n<=14
				if colt<=1
					lchartBar(C,chartL, totcL, 1:11, indx1, rlBoje, [255-16*(rL_n-11),350],sp);
					rchartBar(C,chartL, totcL, indy2, indx2, rlBoje, [255-16*(rL_n-11),350],sp);
				else
					lchartBar(C,chartL, totcL, 1:11, indx1, rlBoje, [350,350],sp);
					rchartBar(C,chartL, totcL, indy2, indx2, rlBoje, [350,350],sp);
					heading(4,naslov);
					baza5(base5,base5L,base5N);
				end
			else
				lchartBar(C,chartL, totcL, [], indx1, rlBoje, [420,350],sp);
				rchartBar(C,chartL, totcL, indy2, indx2, rlBoje, [420,350],sp);
				heading(4,naslov);
				baza5(base5,base5L,base5N);
			end
		else %crtamo samo jedan grafik, marginalnih procenata
			if rL_n<=5
				if colt<=1
					if (ktype==1 | ktype ==4) & max(size(indx1))==1
						chartPie(C,chartL, totcL, [], indx1, rlBoje, [250,450],sp);
					else
						chartBar(C,chartL, totcL, [], indx1, rlBoje, [250,450],sp);
					end
				elseif colt==2
					if (ktype==1 | ktype ==4) & max(size(indx1))==1
						chartPie(C,chartL, totcL, [], indx1, rlBoje, [180,410],sp);
					else
						chartBar(C,chartL, totcL, [], indx1, rlBoje, [180,410],sp);
					end
				else
					if (ktype==1 | ktype ==4) & max(size(indx1))==1
						chartPie(C,chartL, totcL, [], indx1, rlBoje, [260,470],sp);
					else
						chartBar(C,chartL, totcL, [], indx1, rlBoje, [260,470],sp);
					end
					heading(4,naslov);
					baza5(base5,base5L,base5N);
				end
			elseif rL_n<=10
				if colt<=1
					chartBar(C,chartL, totcL, [], indx1, rlBoje, [250,450],sp);
				else
					chartBar(C,chartL, totcL, [], indx1, rlBoje, [350,450],sp);
					heading(4,naslov);
					baza5(base5,base5L,base5N);
				end
			elseif rL_n<=14
				if colt<=1
					chartBar(C,chartL, totcL, 1:11, indx1, rlBoje, [255-16*(rL_n-11),450],sp);
				else
					chartBar(C,chartL, totcL, 1:11, indx1, rlBoje, [350,450],sp);
					heading(4,naslov);
					baza5(base5,base5L,base5N);
				end
			else
				chartBar(C,chartL, totcL, [], indx1, rlBoje, [420,450],sp);
				heading(4,naslov);
				baza5(base5,base5L,base5N);
			end
		end
	end
	i=1;
	repeat
		if transpose
			if outputType
				indx = find(cL#i=="~");
				if any(indx)
					cL#i(indx) = "|";
				end
				indx = find(rL#i=="|");
				if any(indx)
					rL#i(indx) = "~";
				end
				indx1 = find(CS#i=="|");
				indx2 = find(CS#i=="~");
				if any(indx1)
					CS#i(indx1) = "~";
				end
				if any(indx2)
					CS#i(indx2) = "|";
				end
			end
			print(CS#i',cL#i',rL#i',BojaF#i',BojaB#i',LinCol#i',LinRow#i');
		else
		%size(CS#i)
		%size(LinCol#i)
		%size(LinRow#i)
			print(CS#i,rL#i,cL#i,BojaF#i,BojaB#i,LinRow#i,LinCol#i);
		end
		if foot~=""
			echo(foot);
		end
		printf("\n")
		i = i+1;
	until i>colt
end

function stableMiss(M', setInd, RFDK)
% M je Mx3 matrica sa vrednostima za missing
% setInd je 0/1 da li se vrednost setuje ili iskljucuje
% RFDK je vrednost
	indx = find(M(:,3)==RFDK);
	if any(indx)
		M(indx,3)=NaN;
	end
	indx = find(M(:,2)==RFDK);
	if any(indx)
		M(indx,2)=M(indx,3);
		M(indx,3)=NaN;
	end
	indx = find(M(:,1)==RFDK);
	if any(indx)
		M(indx,1:2)=M(indx,2:3);
		M(indx,3)=NaN;
	end
	if setInd
		indx = find(M(:,3)==NaN & M(:,1)~=NaN & M(:,2)~=NaN);
		if any(indx)
			M(indx,3)=RFDK;
		end
		indx = find(M(:,2)==NaN & M(:,1)~=NaN);
		if any(indx)
			M(indx,2)=RFDK;
		end
		indx = find(M(:,1)==NaN);
		if any(indx)
			M(indx,1)=RFDK;
		end
	end
end

macro mc_miss
	global RF, DK

	lok_mis = ucase(lok_mis);

	Indx = [];
	indx = find(lok_mis=="NONE");
	if any(indx)
		if max(size(lok_mis))>1
			error("If specified NONE has to be only only value")
		end
		lNONE = 1;
		Indx = [Indx;indx];
	else
		lNONE = 0;
	end

	indx = find(lok_mis=="RF");
	if any(indx)
		lRF = 1;
		Indx = [Indx;indx];
	end
	indx = find(lok_mis=="DK");
	if any(indx)
		lDK = 1;
		Indx = [Indx;indx];
	end

	indx = find(lok_mis=="NORF");
	if any(indx)
		lRF = 0;
		Indx = [Indx;indx];
	end
	indx = find(lok_mis=="NODK");
	if any(indx)
		lDK = 0;
		Indx = [Indx;indx];
	end
	if any(Indx)
		lok_mis(Indx)=[];
	end
	if size(lok_mis,1)
		lok_mis = str2num(lok_mis);
		if (lok_mis anyin tot_lok_mis)
			for lm=1:max(size(lok_mis))
				lm_i = find(tot_lok_mis == lok_mis(lm));
				if (lm_i~=[])
					tot_lok_mis(lm_i) = [];
				end
			end
		end
		if (lRF~=NaN & lRF~=0)+(lDK~=NaN & lDK~=0)+max(size(tot_lok_mis))+max(size(lok_mis))>3
			error("More then 3 missing values are specified")
		end
		tot_lok_mis = [tot_lok_mis,lok_mis];
		clear lok_mis;
	end
end

function c = RGB(r,g,b)
  c = ((b * 256) + g) * 256 + r;
end

function b = slope(Y)
    n = size(Y,1);
    x = 1:n;
    sdy=sd(Y)'*n/(n-1);
    ind = find(sdy==0);
    
    m=1:size(Y,2);
    mm = size(Y,2);
    if ind~=[]
        Y(:,ind) = [];
        m(ind) = [];
		r = zeros(mm,1);
		if Y~=[]
          rr = corr(Y,x);
		  r(m) = rr;
		end
    else
        r = corr(Y,x);
    end;
    

    
    sdx=sd(x)*n/(n-1);
    X = [ones(size(x)),x];
    b = r.*sdy/sdx;

    %(X'*X)^*X'*Y
    
    t=r.*sqrt((n-2)./(1-r.^2));
    sig = 1-tcdf(abs(t),(n-2));

    b = [b, sig, (sig<0.05)+1];
end