function mul2bin(vars,prefix,options)
	if def(vars)
		vars=ucase(vars);
	else
		error("Nije specificiran 'vars' argument")
	end
	if def(prefix)
		prefix=ucase(prefix);
	else
		error("Nije specificiran 'prefix' argument")
	end
	rewrite = 0;
	origval = 0;
	fromlab = 0;
	opt = ["rewrite";"origval";"fromlabs"];
	if def(options); 
		options = lcase(options);
		for i=1:max(size(options))
			j = strlen(options(i));
			if (j)
				k = find(left(opt,j)==options(i));
				if k==[]
					error("Nepoznat parametar u OPTIONS");
				elseif max(size(k))>1
					error("Parametar u OPTIONS nije nedvosmisleno definisan");
				elseif k==1;
					rewrite = 1;
				elseif k==2;
					origval = 1;
				elseif k==3;
					fromlab = 1;
				end
			end
		end
	end

	if (fromlab)
		[lab, val]=GetNumLabel(vars(1));
		val1 = size(val,1);
	else
		[val,y]=freq(Data(:,vars));
		val1 = size(val,1);
		if val(val1)==NaN
			val(val1)=[];
			y(val1)=[];
			val1 = val1-1;
		end
	end
	if val1
		%check for existance of variables in data set
		greska = 0;
		for i=1:val1
			newvar = strcat(prefix,num2str("%d",i));
			%printf(" - %s\n", newvar);
			if strlen(newvar)>8
				printf("Predugacko ime za varijablu - %s; probajte sa kracim prefixom\n", newvar);
				greska = 1;
			end
			if ext(newvar)
				if ~rewrite
					printf("Varijabla %s postoji u fajlu\n", newvar);
					greska = 1;
				end
			else
				DataAddVar(newvar);
			end
		end
			
		if greska
			error ("Varijable postoje u fajlu, a niste naveli REWRITE opciju, ili je PREFIX predugacak!");
		end
		varlab = GetVarLabel(vars(1));
		ivarlab = strlen(varlab);
		for i=1:val1
			newvar = strcat(prefix,num2str("%d",i));
			if origval
				Data(:,newvar) = (rsum(Data(:,vars)==val(i))~=0)*val(i);
			else
				Data(:,newvar) = rsum(Data(:,vars)==val(i))~=0;
			end
			numlab = GetNumLabel(vars,val(i));
			indx = find(strlen(numlab));
			if indx~=[]
				numlab = numlab(indx(1));
			else
				numlab = num2str("%d",i);
			end
			inumlab = strlen(numlab);
			fali = 120 - inumlab - ivarlab - 3;
			if  fali>=0
				SetVarLabel(newvar,varlab + " - " + numlab);
			else
				SetVarLabel(newvar,left(varlab,ivarlab+fali-3) + "... - " + numlab);
			end
		end
		printf("Kal successfully created %d new variables!\n",val1);
		DataSave
	end
end