function multiple(name, vars, label, value)
	
	if def(name) & max(size(name))==1
		name=ucase(name(1));
		if left(name,1)~="$"
			name = "$" + name;
		end
		if strlen(name)>8
			error("Navedeno ime za multiplu '"+name+"' je preko 8 karaktera");
		end
	else
		error("Nije specificiran 'name' argument")
	end
	
	if def(vars)
		if max(size(vars)) < 2
			error("Naveli ste manje od dve varijable za multiplu - 'vars' argument")
		else
			vars = ucase(vars);
		end
		resolve_to(vars)
	else
		error("Nije specificiran 'vars' argument")
	end
	
	labVar = "";
	if def(label) & label(1)~=""
		for i=1:max(size(label))
			labVar = labVar+" "+label(i);
		end
		labVar = ltrim(labVar);
	else
		labVar = GetVarLabel(vars);
		indx = find(strlen(labVar));
		if indx~=[]
			labVar = labVar(indx(1));
		else
			labVar = name + " - MULTIPLE";
		end
	end
	
	if def(value)
		if size(value,1)
			if isstr(value)
				value = str2num(value);
			end
		else
			value = [];
		end
	else
		value = [];
	end
	
	if value~=[]
		DataAddMVar(name,vars,value)
	else
		DataAddMVar(name,vars)
	end
	SetVarLabel(name,labVar);
end