function poltab2(vars, col1, col2, col3, statistics, ltperc, label, srtvl, filter, options, missing, select)

	if def(vars)
		vars=ucase(vars);
		vars = resolveSet(vars);
	else
		error("Argument 'vars' is not specified")
	end

	colt = 0;
	for cj=1:3
		if def(col#cj)
			if size(col#cj,1)==0
				col#cj="";
			else
				if colt<cj-1;error("Argument 'col"+num2str("%d",cj-1)+"' is not specified");end
				col#cj=resolveSet(ucase(col#cj));
				colt = colt+1;
			end
		else
			col#cj = "";
		end
	end
	
	global g_ltperc;
	if def(ltperc) & size(ltperc,1)
		ltperc = str2num(ltperc);
		if prod(size(ltperc))~=2
			error("Argument 'ltpers' have to have 2 parameters")
		end
	elseif g_ltperc~=[]
		ltperc = g_ltperc;
	else
		ltperc = [];
	end

	global g_srtvl;
	if def(srtvl) & size(srtvl,1)
		srtvl = srtvl(1);
		srtvl = str2num(srtvl);
	elseif g_srtvl~=[]
		srtvl = g_srtvl;
	else
		srtvl = [];
	end

	global g_statistics;
	if def(statistics)
		statistics = ucase(statistics);
		statistics = statistics(:);
		if size(statistics,2)<size(statistics,1)
			statistics = statistics';
		end
	elseif size(g_statistics,1)
		statistics = g_statistics;
	else
		statistics = ["COUNT","COLPCT"];
	end

	lRF = NaN;
	lDK = NaN;
	tot_lok_mis = [];
	global g_missing;
	if size(g_missing,1)
		lok_mis = g_missing;
		pmc_miss;
	end
	if def(missing)
		lok_mis = missing;
		pmc_miss;
	end
	
	labVar = "";
	if def(label) & label(1)~=""
		for i=1:max(size(label))
			labVar = labVar+" "+label(i);
		end
	end

	if ~def(filter);
		if colt
			filter = make(colt,1,"");
		else
			filter = make(1,1,"");
		end
	else
		filter = ucase(filter);
		i = prod(size(filter));
		if i ~= colt
			if colt==0
				filter = make(i,1,filter);
			elseif i==1
				filter = make(colt,1,filter);
			else
				error("Argument 'filter' if defined more than once, has to be degined for each column group");
			end
		end
		k=find(filter=="ALL");
		if k~=[]
			filter(k)=filter_name;
		end
	end
	
	if def(select)
		if strlen(filter_name)
			filter_old = filter_name;
			DataSelect();
		else
			filter_old = "";
		end
		SEL = calcFilter(select);
		DataSelect(filter_old);
	else
		SEL = [];
	end

	opt = [ "ascending"
			"descending"
			"sysmis"
			"nozerocolumns"
			"unwn"
			"non"
			"nobase"
			"samplesize"
			"ownbase"
			"count"
			"share"
			"trim" %12
			"notrim"
			"nototal1"
			"nototal2"
			"nototal3"
			"nototal4"
			"nototal5"
			"nototal6"
			"nototal7"
			"nototal8"
			"top5"
			"transpose"
			"plus"
			"labvals"
			"rlabvals"
			"clabvals"
			"nochart"
			"label_sort"]; %29
	opt_off = "$"+opt;
	sort = 0;
	nototal = zeros(1,15);
	unwn = 0;
	base5 = 1;
	BTopts = "noprint";
	wghn = 1;
	strStats = "colpct";
	trim = 0;
	top5=0;
	transpose=0;
	label_sort = 0;
	sysmis = 0;
	
	global g_options;
	if (size(g_options,1))
		if def(options)
			for i=1:max(size(g_options))
				if ~any(options==g_options(i))		
					options = [options,g_options(i)];
				end
			end
		else
			options = g_options;
		end
	end
	
	ko_arr = make(size(opt_off),1);
	if def(options);
		options = lcase(options);
		for i=1:max(size(options))
			j = strlen(options(i));
			ko = find(left(opt_off,j)==(options(i)));
			if max(size(ko))>1
				error("Parametar in OPTIONS is not uniquely defined");
			elseif ko~=[]
				ko_arr(ko)=0;
			end
		end
		for i=1:max(size(options))
			j = strlen(options(i));
			k = find(left(opt,j)==options(i));
			ko = find(left(opt_off,j)==(options(i)));
			if k==[]
				if ko==[]
					error("Unknown parametar in OPTIONS");
				end
			elseif max(size(k))>1
				error("Parametar in OPTIONS is not uniquely defined");
			elseif k==1 & ko_arr(k)
				sort=1;
			elseif k==2 & ko_arr(k)
				sort=-1;
			elseif k==3 & ko_arr(k)
				BTopts = [BTopts,"sysmis"];
				sysmis = 1;
			elseif k==4 & ko_arr(k)
				BTopts = [BTopts,"nozerocolumns"];
			elseif k==5 & ko_arr(k)
				unwn = 1;
			elseif k==6 & ko_arr(k)
				wghn = 0;
			elseif k==7 & ko_arr(k)
				base5 = 0;
			elseif k==8 & ko_arr(k)
				BTopts = [BTopts,"samplesize"];
			elseif k==9 & ko_arr(k)
				BTopts = [BTopts,"ownbase"]; %radi se svaki red posebno, nema jedinstvene baze
				base5 = 0; %bez veze je onda baza, kada je svaka varijabla za sebe
				%wghn = 0;
			elseif k==10  & ko_arr(k)
				strStats = "count";
				if ~defdecimal
					decimal = [0 0];
				end
			elseif k==11  & ko_arr(k)
				strStats = "colshare";
			elseif k==12 & ko_arr(k)
				trim=1;
			elseif k==13 & ko_arr(k)
				trim=0;
			elseif k==14 & ko_arr(k)
				nototal(1)=1;
			elseif k==15 & ko_arr(k)
				nototal(2)=1;
			elseif k==16 & ko_arr(k)
				nototal(3)=1;
			elseif k==17 & ko_arr(k)
				nototal(4)=1;
			elseif k==18 & ko_arr(k)
				nototal(5)=1;
			elseif k==19 & ko_arr(k)
				nototal(6)=1;
			elseif k==20 & ko_arr(k)
				nototal(7)=1;
			elseif k==21 & ko_arr(k)
				nototal(8)=1;
			elseif k==22 & ko_arr(k)
				top5=1;
			elseif k==23 & ko_arr(k)
				transpose=1;
			elseif k==24 & ko_arr(k)
				BTopts = [BTopts,"plus"];
			elseif k==25 & ko_arr(k)
				BTopts = [BTopts,"labvals"];
			elseif k==26 & ko_arr(k)
				BTopts = [BTopts,"rlabvals"];
			elseif k==27 & ko_arr(k)
				BTopts = [BTopts,"clabvals"];
			elseif k==28 & ko_arr(k)
				chart = NaN;
			elseif k==29 & ko_arr(k)
				label_sort = 1;
			end
		end
	end

	boje; %poziva definicije boja u boje.s

	broj_iteracija = prod(size(vars));
	simple = 1;

	j = 1;
	while j<=broj_iteracija
		ssimple = 0;

		varijabla = vars(j);
		if left(varijabla,1)=="$"
			ssimple = 0;
		else
			ssimple = 1;
		end
		if j<broj_iteracija & vars(j+1)=="#"
			k = 2;
			while (j+k<=broj_iteracija & vars(j+k)~="#")
				k=k+1;
			end
			if j+k>broj_iteracija
				error("Afer variable '" + vars(j) + "' operator # is not enclosed.")
			end
			varijabla = vars(j:(j+k));
			j = j+k;
		end

		j = j+1;
		if def(missing) | size(g_missing,1)
			varss = GetVarName(varijabla);
			[missT, missS] = GetMissVal(varss);
			misT = missT;
			misS = missS;
			if sum(misT<0)
				error("Variable "+varijabla+" has defined 'range' for missing values, which is not supported yet")
			end
			
			if lNONE==1
				misT = make(size(missT),NaN);
				misS = make(size(missS),NaN);
			end
			if lRF~=NaN
				poltabMiss(misS, lRF, RF);
			end
			if lDK~=NaN
				poltabMiss(misS, lDK, DK);
			end
			if size(tot_lok_mis,1)
				for i=1:max(size(tot_lok_mis))
					stableMiss(misS, 1, tot_lok_mis(i))
				end
			end
			misT = rsum(misS~=NaN);
			SetMissVal(varss, misT, misS)
		end
		totC = [];
		totRes = [];
		totcGrn = [];
		totcL = ["";""];
		totwghN = [];
		i=0;
		repeat
			i = i+1;
		%for i=1:colt
			ukljuciFilterP;
			if (ssimple)
				[C,Res,rL,cL,cGrn,rGrn,rNum,cNum,wghN,unwN] = bigtab([varijabla,"$total"],["$total",col#i],strStats,"statisticsincol",ltperc,srtvl,BTopts);
				srL = size(rL,1);
				rL(srL,2)=rL(srL,1);
				rL(srL,1)="";
				srL = srL-1;
			else
				[C,Res,rL,cL,cGrn,rGrn,rNum,cNum,wghN,unwN] = bigtab(varijabla,["$total",col#i],strStats,"statisticsincol",ltperc,srtvl,BTopts);
				srL = size(rL,1);
			end
			
			

			
			%%%%%%%%%%%echo(strRw);
			if ~prod(size(statistics)==size(strStats)) | prod(statistics==strStats)==0
				if (ssimple)
					[C,Res,rL,cL,cGrn,rGrn,rNum,cNum,wghN,unwN] = bigtab([varijabla,"$total"],["$total",col#i],statistics,"statisticsincol",ltperc,srtvl,BTopts);
					srL = size(rL,1);
					rL(srL,2)=rL(srL,1);
					rL(srL,1)="";
					srL = srL-1;
				else
					[C,Res,rL,cL,cGrn,rGrn,rNum,cNum,wghN,unwN] = bigtab(varijabla,["$total",col#i],statistics,"statisticsincol",ltperc,srtvl,BTopts);
					srL = size(rL,1);
				end
			end

			if labVar ~= ""
				naslov = labVar;
				rL(:,[1,3])=[];
			else
				naslov = rL(1,1);
			end
			
			%rL(:,1)=[];
			rL(1:srL,1) = rL(1:srL,2); 
			rL(1:srL,2) = num2str("{%d}",1:srL);

			brojCol = cL(2,:);
			mss = max(size(statistics));
			p = ((size(brojCol,2)-mss)/mss);
			p = 0:p;
			brojCol(1:size(brojCol,2):mss) = num2str("{%d}",p');
			
			%cL = [cL;brojCol];
			if ssimple
				_a = size(rL,1);
				_rL    = rL(_a,:);
				_C     = C(_a,:);
				_rNum  = rNum(_a,:);
				rL(_a,:) = [];
				C(_a,:) = [];  
				rNum(_a,:) = [];
			end
			sortiranjeCP;
			if ssimple
				rL(_a,:) = _rL; 
				C(_a,:) = _C;  
				rNum(_a,:) = _rNum;
			end
			
			rL(1:srL,2) = num2str("{%d}",1:srL);
			C
			statistics
			strStats
			plus = find(statistics=="COUNT");
			plus = plus(1)
			maxstat= max(size(statistics));
			Count = C(:,(maxstat+plus):Inf:maxstat)
			ind = find(Count==0);
			if ind~=[]
				Count(ind)=NaN;
			end

			n = wghN(2:Inf);
			Pct = C(:,(maxstat+plus):Inf:maxstat)/100;
			sv = ones(size(n,2),1);
			N = sv * n;
			
			CountT = abs(-(Count - C(:,plus)))
			ind = find(CountT==0);
			if ind~=[]
				CountT(ind)=NaN;
			end

			nT = -(n - wghN(1));
			PctT = CountT./nT;
			
			
			PctT
			CountT
			Pct
			Count
			
			PtT = (PctT.*CountT+Pct.*Count)./(CountT+Count);
			ST = sqrt(PtT.*(1-PtT).*(1./CountT+1./Count));
			ZT = (PctT - Pct)./ST;
			pT = 2*normcdf(-abs(ZT));
			
			strRow = "";
			for rw=1:size(Pct,1)-ssimple
				strRw = "";
				for rwi=1:size(pT,2)
					if (pT(rw, rwi)<0.05)
						strRw = strRw + sprintf(" 0 - %d;",rwi);
					end
				end
				
				P = sv * Pct(rw,:);
				PN = sv * Count(rw,:);
				Pt = (PN'+PN)./(N'+N);
				S = sqrt(Pt.*(1-Pt).*(1./N+1./N'));
				Z = (P - P')./S;
				p = 2*normcdf(-abs(Z));
				
				for rwi=1:size(p,1)-1
					for rwj=2:size(p,1)
						if (p(rwi, rwj)<0.05)
							strRw = strRw + sprintf(" %d - %d;",rwi,rwj);
						end
					end
				end
				if strRw ~=""
					strRw = sprintf("Row %d:",rw) + strRw;
					strRow = [strRow;strRw];
				end
			end
			strRow(1)=[];
			
			indx0 = find(C==NaN);
			CS = num2str("%0.0f",C);
			for jms=2:mss
				CS(size(CS,1),jms:size(CS,2):mss)="~";
			end
			CS(size(CS,1),1:size(CS,2):mss)=num2str("%0.0f",wghN);
			if outputType
				apsC = abs(C);
				indx = find(C<0);
				if any(indx)
					apsC(indx) = apsC(indx)*10;
				end
				m1 = mmax(apsC);
				m2 = strlen(num2str("%0.0f",m1));
				m2 = 10^(m2-1);
	
				while m2>1
					indx = find(apsC<m2);
					if indx~=[]
						CS(indx)="#"+CS(indx);
					end
					m2 = m2/10;
				end
			end
			if any(indx0)
				CS(indx0)="";
			end
			LinCol = make(1, max(max(cGrn)), NaN); %pravljenje linija
			LinCol(cGrn(2,:)) = 2;                 %za kolone
			LinRow = make(size(rL,1)-1,1,NaN); %Debljina linije za redove, na koje se dodaje gore i dole
			
			LinCol = [make(1,size(rL,2),NaN), 2, LinCol];
			LinRow = [make(size(cL,1),1,NaN); LinRow];
			LinRow = [1;LinRow];
			
			if filter(1)==filter(i) %ovo je bitno jer ako su razliciti filteri stampa se prva tabela
				chartL = rL;
			end

			
			if filter(1)==filter(i)
				totC = [totC,C];
				totRes = [totRes,Res];
				if totcGrn ==[]
					totcGrn = cGrn;
				else
					totcGrn = [totcGrn,cGrn+totcGrn(2,size(totcGrn,2))];
				end
				totcL = [totcL,cL(size(cL,1)-1:size(cL,1),:)];
				totwghN = [totwghN,wghN];
			end
			
			CS = [brojCol;CS];
			
			BojaF = make(size(CS)+[size(cL,1),size(rL,2)],NaN);
			BojaB = BojaF;
			BojaB(1,:) = LBColor(3);                %Tamnije plavo za prvi red
			BojaF(1,:) = LFColor(3);               %Tamnije plavo za prvi red
			
			BojaF(size(cL,1)+1,:) = LFColor(1);
			BojaB(size(cL,1)+1,:) = LBColor(1);
			
			if ssimple
				BojaF(size(cL,1)+size(CS,1),:) = LFColor(2);
				BojaB(size(cL,1)+size(CS,1),:) = LBColor(2);
				LinRow(size(LinRow,1))=3;
				%LinRow(size(rL,1)+1)=3;
			end
			LinRow = [1;LinRow;1];
			
			
			C#i = C;
			cL#i = cL;
			CS#i = CS;
			rL#i = [make(1,size(rL,2),"");rL];
			LinRow#i = LinRow;
			LinCol#i = LinCol;
			BojaF#i = BojaF;
			BojaB#i = BojaB;
			strRow#i = strRow;
			%rNum#i = rNum;
			%cNum#i = cNum;
			%Res#i = Res;
			%wghN#i = wghN;
			%unwN#i = unwN;
			%cGrn#i = cGrn;rGrn#i = rGrn;
			
			
			iskljuciFilterP;
		until (i>=colt);
		if def(missing)
			SetMissVal(varss, missT, missS)
		end
		totcL(:,1)=[]; %brisemo one gluposti sa pocetka
		
		chartANDtablesP;
	end
end


macro ukljuciFilterP
	if strlen(filter(i)) | SEL~=[]
		if strlen(filter_name)
			filter_old = filter_name;
		else
			filter_old = "";
		end
		DataSelect();
		k = 0;
		repeat
			k = k+1;
			filter_new = "FILT" + num2str("%d",k);
		until (~vext(filter_new))
		DataAddVar(filter_new);
		deleteFil = 1;
		if strlen(filter(i))
			if SEL == []
				Data(:,filter_new) = Data(:,filter_old) & Data(:,filter(i));
			else
				Data(:,filter_new) = Data(:,filter_old) & Data(:,filter(i)) & SEL;
			end
		elseif SEL~=[]
			if strlen(filter_old)
				Data(:,filter_new) = Data(:,filter_old) & SEL;
			else
				Data(:,filter_new) = SEL;
			end 
		end
	end
end

macro iskljuciFilterP
	if strlen(filter(i)) | SEL ~= []
		DataSelect(filter_old);
		if deleteFil
			DataDelVar(filter_new);
		end
	end
end

macro sortiranjeCP
	aa  = max(size(rNum));
	vise = 1;
	if (rNum(aa)==NaN)
		vise=2;
	end
	if (sort | label_sort) & size(C,1)>vise
		if (vise==2)
			rLmiss = rL(aa);
			rL(aa)=[];
			Cmiss = C(aa,:);
			C(aa,:) = [];
			Resmiss = Res(aa,:);
			Res(aa,:) = [];
			rNum(aa) = [];
		end
		if label_sort
			rL_lok = rL;
			if sort<0
				[rL indx] = sortd(rL);
			else
				[rL indx] = sorta(rL);
			end
			%for i_=1:size(rL,1)
			%	indx_lok = find(rL_lok==rL(i_));
			%	if max(size(indx_lok))>1
			%		error("Multiple value labels '"+rL(i_)+"' with label_sort option is not alowed");
			%	end
			%	indx(i_) = indx_lok;
			%end
		else
			if srtvl~=[] & (max(size(rNum))~=1)
				indx = find(rNum<srtvl)
				if size(indx,1)>1
					indx = [indx,C(indx,1)];
					if sort<0
						sortd(indx,2);
					else
						sorta(indx,2);
					end
					indxF = indx(:,1);
				else
					indxF = indx;% indxF=[]
				end
				
				indx = find(rNum>=srtvl);
				if size(indx,1)>1
					indx = [indx,rNum(indx)];
					sorta(indx,2);
					indx = [indxF;indx(:,1)];
				else
					indx = [indxF;indx];
				end
			else
				indx = 1:size(C,1);
				indx = [indx,C(:,1)];
				if size(indx,1)>1
					if sort<0
						sortd(indx,2);
					else
						sorta(indx,2);
					end
				end
				indx = indx(:,1);
			end
			rL = rL(indx,:);
		end
		C = C(indx,:);
		if (max(size(rNum))~=1)
			rNum = rNum(indx,:);
		end
		Res = Res(indx,:);
		if (vise==2)
			rL = [rL;rLmiss];
			C = [C;Cmiss];
			Res = [Res;Resmiss];
			rNum = [rNum;NaN];
		end
	end
end


macro chartANDtablesP
	
	heading(3,naslov)
	
	i=1;
	repeat
		if transpose
			if outputType
				indx = find(cL#i=="~");
				if any(indx)
					cL#i(indx) = "|";
				end
				indx = find(rL#i=="|");
				if any(indx)
					rL#i(indx) = "~";
				end
				indx1 = find(CS#i=="|");
				indx2 = find(CS#i=="~");
				if any(indx1)
					CS#i(indx1) = "~";
				end
				if any(indx2)
					CS#i(indx2) = "|";
				end
			end
			print(CS#i',cL#i',rL#i',BojaF#i',BojaB#i',LinCol#i',LinRow#i');
		else  
		%size(CS#i)    
		%size(rL#i)
		%size(cL#i)    
		%size(LinCol#i)
		%size(LinRow#i)     
			print(CS#i,rL#i,cL#i,BojaF#i,BojaB#i,LinRow#i,LinCol#i);
		end
		printf("\n")
		if size(strRow#i,1)
			if outputType==3 %Excel
				print(make(size(strRow#i,1),1,""),strRow#i,[])
			else
				for q=1:size(strRow#i,1)
					echo(strRow#i(q)+"\n");
				end
			end
			printf("\n\n")
		end
		i = i+1;
	until i>colt
end

function poltabMiss(M', setInd, RFDK)
% M je Mx3 matrica sa vrednostima za missing
% setInd je 0/1 da li se vrednost setuje ili iskljucuje
% RFDK je vrednost
	indx = find(M(:,3)==RFDK);
	if any(indx)
		M(indx,3)=NaN;
	end
	indx = find(M(:,2)==RFDK);
	if any(indx)
		M(indx,2)=M(indx,3);
		M(indx,3)=NaN;
	end
	indx = find(M(:,1)==RFDK);
	if any(indx)
		M(indx,1:2)=M(indx,2:3);
		M(indx,3)=NaN;
	end
	if setInd
		indx = find(M(:,3)==NaN & M(:,1)~=NaN & M(:,2)~=NaN);
		if any(indx)
			M(indx,3)=RFDK;
		end
		indx = find(M(:,2)==NaN & M(:,1)~=NaN);
		if any(indx)
			M(indx,2)=RFDK;
		end
		indx = find(M(:,1)==NaN);
		if any(indx)
			M(indx,1)=RFDK;
		end
	end
end

macro pmc_miss
	global RF, DK

	lok_mis = ucase(lok_mis);
	
	Indx = [];
	indx = find(lok_mis=="NONE");
	if any(indx)
		if max(size(lok_mis))>1
			error("If specified NONE has to be only only value")
		end
		lNONE = 1;
		Indx = [Indx;indx];
	else
		lNONE = 0;
	end
	
	indx = find(lok_mis=="RF");
	if any(indx)
		lRF = 1;
		Indx = [Indx;indx];
	end
	indx = find(lok_mis=="DK");
	if any(indx)
		lDK = 1;
		Indx = [Indx;indx];
	end
	
	indx = find(lok_mis=="NORF");
	if any(indx)
		lRF = 0;
		Indx = [Indx;indx];
	end
	indx = find(lok_mis=="NODK");
	if any(indx)
		lDK = 0;
		Indx = [Indx;indx];

	end
	if any(Indx)
		lok_mis(Indx)=[];
	end
	if size(lok_mis,1)
		lok_mis = str2num(lok_mis);
		if (lok_mis anyin tot_lok_mis)
			for lm=1:max(size(lok_mis))
				lm_i = find(tot_lok_mis == lok_mis(lm));
				if (lm_i~=[])
					tot_lok_mis(lm_i) = [];
				end
			end
		end
		if (lRF~=NaN & lRF~=0)+(lDK~=NaN & lDK~=0)+max(size(tot_lok_mis))+max(size(lok_mis))>3
			error("More then 3 missing values are specified")
		end
		tot_lok_mis = [tot_lok_mis,lok_mis];
		clear lok_mis;
	end
end