function resolve_to(vars')
	indx = find(vars=="TO");
	for i=size(indx,1):1:-1
		if indx(i)==1
			error("Missing starting variable in operator 'to'");
		end
		from = vars(indx(i)-1);
		if indx(i)==max(size(vars))
			error("Missing ending variable in operator 'to'");
		end
		to = vars(indx(i)+1);
		poz1 = 1;
		while str2num(left(right(from,poz1),1))~=NaN
			poz1 = poz1+1;
		end
		poz1 = poz1-1;
		from_st = left(from, strlen(from)-poz1);
		from_num = str2num(right(from,poz1));
		
		poz2 = 1;
		while str2num(left(right(to,poz2),1))~=NaN
			poz2 = poz2+1;
		end
		
		poz2 = poz2-1;
		to_st = left(to, strlen(to)-poz2);
		to_num = str2num(right(to,poz2));
		
		if (from_st~=to_st)
			error("Operator 'to' should be used like 'a1 to a10'")
		end
		
		if from_num<to_num
			from_num=from_num+1;
			to_num = to_num-1;
			vars = [vars(1:indx(i)-1),from_st+num2str("%d",(from_num:to_num)'),vars(indx(i)+1:NaN)];
		else
			from_num=from_num-1;
			to_num = to_num+1;
			vars = [vars(1:indx(i)-1),from_st+num2str("%d",(from_num:to_num:-1)'),vars(indx(i)+1:NaN)];
		end
	end
end