function set(name, vars, decimal, color, ltperc, srtvl, value, options, statistics, missing, col, col1, col2, col3, boxes, footer, reScaleWeight)

	if def(name)
		if max(size(name))~=1
			error("'name' argument is not specified right way.")
		end
		name=ucase(name(1));
		if left(name,2)~="$$"
			if left(name,1)=="$"
				name = "$" + name;
			else
				name = "$$" + name;
			end
		end
		if def(vars)
			vars = ucase(vars);
		else
			error("'vars' argument is not specified")
		end
		resolve_to(vars)
		eval("global "+name+";"+name+"=vars;")
	end

	if def(decimal)
		if max(size(decimal))==0 | max(size(decimal))>3
				error("Argument 'decimal' can have maximum of 3 parameters")
		end
		decimal = str2num(decimal);
		if max(size(decimal))==1
			decimal = make(1,2,decimal);
		end
		global g_decimal; 
		g_decimal = decimal;
	end

	if def(color) & size(color,1)~=0
		global g_color;
		g_color =str2num(color);
	end

	if def(ltperc) & size(ltperc,1)
		ltperc = str2num(ltperc);
		if prod(size(ltperc))~=2
			error("Argument 'ltpers' must have 2 parameters")
		end
		global g_ltperc;
		g_ltperc = ltperc;
	end

	if def(srtvl) & size(srtvl,1)
		global g_srtvl;
		g_srtvl = str2num(srtvl(1));
	end
	
	if def(reScaleWeight) & size(reScaleWeight,1)
		global g_reScaleWeight;
		g_reScaleWeight = str2num(reScaleWeight(1));
	end
	

	if def(value) & size(value,1)
		global g_value;
		g_value = str2num(value);
	end

	if def(col)
	  global g_col
		g_col = col;
	end

	if def(col1)
	  global g_col1
		g_col1 = col1;
	end

	if def(col2)
	  global g_col2
		g_col2 = col2;
	end

	if def(col3)
	  global g_col3
		g_col3 = col3;
	end
	if def(chart)
		global g_chart;
		if max(size(chart))
			if max(size(chart))>2
				error("Argument 'chart' can have maximum of 2 parameters")
			end
			g_chart = str2num(chart);
		end
	end

	if def(options)
		global g_options;
		if size(g_options,1)==0
			g_options = options(1);
		end
		for i=1:max(size(options))
			if ~any(g_options==options(i))
				g_options = [g_options;options(i)];
			end
		end
	end

	if def(statistics)
		statistics = ucase(statistics);
		statistics = statistics(:);
		if size(statistics,2)<size(statistics,1)
			statistics = statistics';
		end
		global g_statistics
		g_statistics = statistics;
	end

	if def(missing)
		missing = ucase(missing);
		global g_missing
		g_missing = missing;
	end

	if def(boxes)
		%boxes = ucase(missing);
		m = max(size(boxes));
		if mod(m,4)
			error("Argumnet boxes is not well defined");
		end
		for i=3:m:4
			if boxes(i)~=":"
				error("Argumnet boxes is not well defined");
			end
		end
		global g_boxes
		g_boxes = boxes;
	end

	if def(footer)
		global g_footer;
		foot = footer(1);
		for i=2:max(size(footer))
			foot = foot+" "+footer(i);
		end
		g_footer = foot;
	end
end