%ver3
%sa varijabilnom pocetnom tackom
%dodato i ponavljanje



h_1 = WndCreat ([], "Sample Step", [NaN,NaN,337,400], 2);

h_2 = CtrCreat (h_1, 150, [153,105,30,18], "","");
h_3 = CtrCreat (h_1, 150, [153,185,30,18], "","");
h_4 = CtrCreat (h_1, 150, [153,265,30,18], "","");
h_12 = CtrCreat (h_1, 150, [153,25,30,18], "","");


CtrCreat (h_1, 510, [9,10,129,13], "Sample variables:");
h_5 = CtrCreat (h_1, 320, [9,25,129,100], uzrvar_ );



CtrCreat (h_1, 510, [193,10,129,13], "Starting point variable:");
h_11 = CtrCreat (h_1, 310, [193,25,129,20], "");

CtrCreat (h_1, 510, [193,50,129,13], "Number of equivalent samples:");
h_20 = CtrCreat (h_1, 410, [193,65,129,20], "1");
CtrCreat (h_1, 510, [193,90,129,13], "Strata sizes:");
h_6 = CtrCreat (h_1, 310, [193,105,129,20], "");

CtrCreat (h_1, 510, [9,132,129,13], "Common variables:");
h_7 = CtrCreat (h_1, 320, [9,147,129,100], zajedvar);
CtrCreat (h_1, 510, [193,132,129,13], "Strata defined by:");
h_8 = CtrCreat (h_1, 320, [193,147,129,100], "");


CtrCreat (h_1, 510, [9,250,129,13], "Population variables:");
h_9 = CtrCreat (h_1, 320, [9,265,129,100],popvar);
CtrCreat (h_1, 510, [193,250,129,13], "Mass varable:");
h_10 = CtrCreat (h_1, 310, [193,265,129,20], "");

h_13 = CtrCreat (h_1, 130, [193,300,130,18], "Without replacement");

CtrCreat (h_1, 110, [193,336,60,25], "OK","sstep_m2;if dalje;WndClose(h_1);sstep_m3;end;");
CtrCreat (h_1, 110, [262,336,60,25], "Cancel","WndClose(h_1);");

CtrConect(h_2,h_5,h_6);
CtrConect(h_3,h_7,h_8);
CtrConect(h_4,h_9,h_10);
CtrConect(h_12,h_5,h_11);


global macro sstep_m2
	dalje=1;
	
	com_v  = CtrGet(h_8);
	if (~size(com_v,1))
		dalje=0;
		MsgBox(h_1,"You mast supply sample stratification variables");
		return
	end
	
	smp_v  = CtrGet(h_6);
	if size(smp_v,1)==0
		MsgBox(h_1, "Pretpostavlja se da samo po jedan uzorak iz svake subpopulacije.");
		smp = ones(size(Uzorak,1),1);
	else
		smp = Uzorak(:,find(~strcmp(smp_v, uzrvar)));
	end
	mas_v = CtrGet(h_10);
	if size(mas_v,1)==0
		MsgBox(h_1, "Pretpostavlja se da svaki entitet u populaciji ima jedinicnu masu.");
		mas = ones(ncase,1);
	else
		mas = Data(:,mas_v);
	end
	bez_ponav = CtrGet(h_13);
	korak_v = CtrGet(h_11);

	a=CtrGet(h_20);
	if strlen(a)
		samples_no = str2num(a);
		if samples_no <= 0
			samples_no = 1;
		end
	else
		samples_no = 1;
	end

end

global macro sstep_m3
	%pravimo Uzorak samo od varijabli koje su odabrane, smp oznacava velicinu
	a=size(com_v,1);
	c=zeros(a,1);
	for i=1:a
		c(i)=find(~strcmp(uzrvar, com_v(i)));
	end
	
	Populacija = Data(:,com_v);
	ind = zeros(size(Populacija,1),1);
	cum = zeros(size(Populacija,1),1);
	sid = zeros(size(Populacija,1),1);

	psu = zeros(size(Populacija,1),1);
	rep = zeros(size(Populacija,1),1);
	
	if size(korak_v,1)
		korak = Uzorak(:,find(~strcmp(uzrvar, korak_v)));
		Uzorak = Uzorak(:,c);
		sstep_m4;
	else
		Uzorak = Uzorak(:,c);
		maxstep = 0;
		minstep = 0;
		for i = 1:size(Uzorak,1)
			if smp(i)
				isto = Populacija==Uzorak(i,:);
				isto = find(rprod(isto));
				if size(isto,1)~=0
					pop_size = sum(mas(isto));
					step = floor(pop_size/smp(i));
					if step > maxstep
						maxstep = step;
					end
					if (minstep == 0) | (minstep>step)
						minstep = step;
					end
				end
			end
		end
		h_1 = WndCreat ([], "Starting point", [NaN,NaN,299,132], 2);
		h_2 = CtrCreat (h_1, 110, [218,73,65,23], "OK","korak = str2num(CtrGet(h_3));WndClose(h_1);sstep_m4;");
		h_3 = CtrCreat (h_1, 410, [11,68,126,18], "100");
		
		CtrCreat (h_1, 510, [12,8,89,13], "Minimalni korak je:");
		CtrCreat (h_1, 510, [119,11,50,13], sprintf("%d",minstep));
	    CtrCreat (h_1, 510, [11,28,92,13], "Maximalni korak je:");
		CtrCreat (h_1, 510, [119,29,50,13], sprintf("%d",maxstep));
		CtrCreat (h_1, 510, [11,50,177,13], "Uneti vrednost za pocetnu tacku u %");
	end
end

global macro sstep_m4	
	if (korak == 100) & (samples_no>1)
		error("ne moze korak od 100, i vise uzoraka, jer to znaci da biramo poslednji te posle njega nema za paralelne verzije uzorka")
	end
	psu_ord = 1;
	for i = 1:size(Uzorak,1)
		if smp(i)
			printf("Sample number : %3d\n",i); 
			%print(Uzorak(i,:));
			isto = Populacija==Uzorak(i,:);
			isto = find(rprod(isto));
			if size(isto,1)==0
				print("Ovde nema ni jedan koji odgovara uzorku")
			else
				pop_size = sum(mas(isto));
				step = floor(pop_size/smp(i));
				uzr_tmp = smp(i);

				check = floor(pop_size/(smp(i)*samples_no));
				if check==0
					printf("   Velicina populacije %d",pop_size);
					printf("   Velicina uzorka     %d",smp(i));
					if (samples_no > 1)
						printf("   Broj uzorka     %d",samples_no);
					end
					error("Pa ne mozes vise u uzorak nego sto ga ima u populaciji")
					uzr_tmp = pop_size;
					step = 1;
				end
				if prod(size(korak))>1
					now_step = floor(step*korak(i)/100);
				else
					now_step = floor(step*korak/100);
				end
				if now_step==0
					now_step = 1;
				end
				totmas = 0;
				for j=1:size(isto,1)
					totmas=totmas+mas(isto(j));
					cum(isto(j)) = totmas;
					while uzr_tmp & totmas>=now_step
						sid(isto(j))= now_step;
						if bez_ponav & ind(isto(j))
							step = floor((pop_size - totmas)/uzr_tmp);
							if step==0
								step = 1;
							end
						else
							ind(isto(j))=ind(isto(j))+1;
							uzr_tmp = uzr_tmp - 1;
						end
						now_step = now_step+step;
					end
				end
				if uzr_tmp
					ind(isto(j))=ind(isto(j))+uzr_tmp;
				end
			end
			if samples_no>1
				j = 1;
				repeat
					if ind(isto(j)) > 0
						psu(isto(j)) = psu_ord;
						rep(isto(j)) = 1;
						for js = 1:samples_no-1
							if ind(isto(j + js)) > 0
								error("Ne moze vise paralelenih uzoraka, nema dodvoljno objekata u populaciji")
							end
							psu(isto(j + js)) = psu_ord;
							rep(isto(j + js)) = js+1;
						end
						j = j + samples_no;
						psu_ord = psu_ord + 1;
					else
						j = j + 1;
					end
				until j > size(isto,1)
			end
		end
	end
	totmas = 1;
	%while (vdef(STEP_#totmas) | vdef(PSU_#totmas)  | vdef(REP_#totmas))
	while (vdef(STEP_#totmas) | vdef(CUM_#totmas) | vdef(SID_#totmas)  | vdef(PSU_#totmas)  | vdef(REP_#totmas))
		totmas = totmas + 1;
	end
	ssv = "STEP_" + num2str("%d",totmas);
	DataAddVar(ssv);
	Data(:,ssv) = ind;
	
	%ssv = "CUM_" + num2str("%d",totmas);
	%ataAddVar(ssv);
	%Data(:,ssv) = cum;
	
	%ssv = "SID_" + num2str("%d",totmas);
	%DataAddVar(ssv);
	%Data(:,ssv) = sid;

	if samples_no>1
		ssv = "PSU_" + num2str("%d",totmas);
		DataAddVar(ssv);
		Data(:,ssv) = psu;
		
		ssv = "REP_" + num2str("%d",totmas);
		DataAddVar(ssv);
		Data(:,ssv) = rep;
	end
	
	%DataDelCase(find(ind==0));
	DataSave("StepSample.sav")
end



