function taboffreq(vars, color, decimal, layout, filter, options, brkat, select, label, footer, boxes)
	% ispravka za brkat, da se ne uzimaju vrednosti koje su vece u mean
	boje; %poziva pre set boje
	if def(vars)
		vars=ucase(vars);
	else
		error("Nije specificiran 'vars' argument")
	end
	global g_color;
	if def(color)
		if size(color,1)==0
			color = 3;
		else
			color = str2num(color);
		end
	elseif g_color~=[]
		color = g_color;
	else
		color = 3;
	end

	if def(layout)
		layout=ucase(layout);
	else
		layout="ROW";
	end
	if def(decimal)
		if size(decimal,1)
			decimal = str2num(decimal);
			if max(size(decimal))>2
				error("Argument 'decimal' nesme da ima vise od dva clana")
			elseif max(size(decimal))==1
				decimal = make(1,2,1) * decimal;
			end
		else
			decimal = [1 1];
		end
	else
		decimal = [1 1];
	end
	if def(brkat) & size(brkat,1)
		if isstr(brkat); brkat = str2num(brkat); end
	else
		brkat = 5;
	end
	if ~def(filter);
		filter = make(1,1,"");
	else
		filter = ucase(filter);
		i = prod(size(filter));
		k=find(filter=="ALL");
		if k~=[]
			filter(k)=filter_name;
		end
	end

	if def(select)
		if strlen(filter_name)
			filter_old = filter_name;
			DataSelect();
		else
			filter_old = "";
		end
		SEL = calcFilter(select);
		DataSelect(filter_old);
	else
		SEL = [];
	end

	lRF = NaN;
	lDK = NaN;

	if def(missing)
		global RF, DK

		missing = ucase(missing);

		Indx = [];
		indx = find(missing=="NONE");
		if any(indx)
			if max(size(missing))>1
				error("Ne moze NONE i jos nesto")
			end
			lNONE = 1;
			Indx = [Indx;indx];
		else
			lNONE = 0;
		end

		indx = find(missing=="RF");
		if any(indx)
			lRF = 1;
			Indx = [Indx;indx];
		end
		indx = find(missing=="DK");
		if any(indx)
			lDK = 1;
			Indx = [Indx;indx];
		end
		indx = find(missing=="NORF");
		if any(indx)
			lRF = 0;
			Indx = [Indx;indx];
		end
		indx = find(missing=="NODK");
		if any(indx)
			lDK = 0;
			Indx = [Indx;indx];

		end
		if any(Indx)
			missing(Indx)=[];
		end
		if size(missing,1)
			if lRF+lDK+max(size(missing))>3
				error("Specificirano je preko 3 missing vrednosti")
			end
			missing = str2num(missing);
		end
	end

	labVar = "";
	if def(label) & label(1)~=""
		for i=1:max(size(label))
			labVar = labVar+" "+label(i);
		end
	end

	opt = [ "total"
			"sum"
			"ca"
			"count"
			"whole"
			"mean"
			"sd"
            "sigc"
            "nobonf"
			"nps"
			"median"];
	opttot = 0;
	optsum = 0;
	optca  = 0;
	optcount = 0;
	optwhole = 0;
	optmean = 0;
	optsd = 0;
	optmedian = 0;
    optsigc = 0;
    nobonf = 0;
    optnps = 0;

	if def(options);
		options = lcase(options);
		for i=1:max(size(options))
			j = strlen(options(i));
			k = find(left(opt,j)==options(i));
			if k==[]
				error("Nepoznat parametar u OPTIONS");
			elseif max(size(k))>1
				error("Parametar u OPTIONS nije unikno definisan");
			elseif k==1;
				opttot = 1;
			elseif k==2;
				optsum = 1;
			elseif k==3;
				optca = 1;
			elseif k==4;
				optcount = 1;
			elseif k==5;
				optwhole = 1;
			elseif k==6;
				optmean = 1;
			elseif k==7;
				optsd = 1;
			elseif k==8;
				optsigc = 1;
            elseif k==9;
				nobonf = 1;
            elseif k==10;
				optnps = 1;
            elseif k==11;
				optmedian = 1;
			end
		end
	end


	

	if def(missing)
		varss = GetVarName(vars);
		[missT, missS] = GetMissVal(varss);
		misT = missT;
		misS = missS;
		if sum(misT<0)
			error("Varijabla "+vars+"ima definisan 'range' za missing values sto jos nije podrzano")
		end
		if lNONE==1
			misT = make(size(missT),NaN);
			misS = make(size(missS),NaN);
		end
		if lRF~=NaN
			tbfMiss(misS, lRF, RF);
		end
		if lDK~=NaN
			tbfMiss(misS, lDK, DK);
		end
		if size(missing,1)
			for i=1:max(size(missing))
				tbfMiss(misS, 1, missing(i))
			end
		end
		misT = rsum(misS~=NaN);
		SetMissVal(varss, misT, misS)
	end




	global g_boxes
	if def(boxes)
		m = max(size(boxes));
		if mod(m,4)
			error("Argumnet boxes is not well defined");
		end
		for i=3:m:4
			if boxes(i)~=":"
				error("Argumnet boxes is not well defined");
			end
		end
	elseif size(g_boxes,1)
		boxes = g_boxes;
	else
		boxes = "";
	end
	if size(boxes,2) > 1
		redovi_za_boxes = max(size(boxes));
		redovi_za_boxes = (redovi_za_boxes - mod(redovi_za_boxes,4)) / 4;
	else
		redovi_za_boxes = 0;
	end

	ukljuciFilterTBF;
	
	W = wgh;
	DD = Data(:,vars);
	[val,fre]=freq(DD);

	if (val(1) > 0)
		centar1 = floor(brkat/2);
		centar2 = ceil(brkat/2) + 1;
	else
		centar1 = floor((brkat+1)/2) - 1;
		centar2 = ceil((brkat+1)/2);
	end

	global g_reScaleWeight;
	if size(g_reScaleWeight,1)
		fndv = find(val == g_reScaleWeight);
		if (size(fndv,1))
			%nw3 = find(Data(:,"NW")==3);
			%if nw3~=[]
			%	totalwgh = sum(W(nw3));
			%	fnd = find(rsum(DD(nw3,:) == g_reScaleWeight));
			%	tmp_wgh_nw3 = W(nw3);
			%	izbaci = sum(tmp_wgh_nw3(fnd));
			%	tmp_wgh_nw3 = tmp_wgh_nw3 * (totalwgh / (totalwgh - izbaci));
			%	tmp_wgh_nw3(fnd) = 0;
			%	W(nw3) = tmp_wgh_nw3;
			%end
			
			tg = rsum(DD == g_reScaleWeight) > 0;
			[val, fre] = freq(Data(:,"NW"));
			for zzz = 1:size(val,1)
				nw3 = find(Data(:,"NW") == val(zzz));
				rcfnd = find(Data(:,"NW") == val(zzz) & tg);
				if rcfnd~=[] 
					tmp_wgh = W;
					totalwgh = sum(tmp_wgh(nw3));
					izbaci = sum(tmp_wgh(rcfnd));
					tmp_wgh(nw3) = tmp_wgh(nw3) * totalwgh / (totalwgh - izbaci);
					tmp_wgh(rcfnd) = 0;
					W = tmp_wgh;
				end
			end
			
			
			
			[val, fre] = freq(Data(:,vars));
			val(fndv) = [];
			fre(fndv) = [];
		end
	end
		
	
	nval = size(val,1);
	if val(nval)==NaN
		nval = nval-1;
	end
	nvar = max(size(vars));
	C = make(nval + optsum*2 + redovi_za_boxes, nvar, 0);
	if optmean+optsd+optmedian
		% MSD = make(optmean +(optsd| optsigc) + optmedian,nvar,0);
		MSD = make(3, nvar, 0);
	else
		MSD=[];
	end
	if optnps
		NPS = make(3,nvar,0);
	else
		NPS=[];
	end
	RC = make(nval + redovi_za_boxes, 1, "");
	N = make(1,nvar,0);

	if size(boxes,2)>1
		for bi=1:redovi_za_boxes
			RC(nval + bi) = boxes((bi-1)*4+1);
		end
	end

	if W~=[]
		for j=1:nvar
			D = Data(:,vars(j));
			N(j) = csum((rsum(D ~= NaN) > 0).*W);
			for i=1:nval
				C(i,j) = csum((rsum(D==val(i))>0).*W);
			end
			if optsum
				C(nval+redovi_za_boxes+1,j) = csum((rsum(D<=centar1)>0).*W);
				C(nval+redovi_za_boxes+2,j) = csum((rsum(D>=centar2 & D<=brkat)>0).*W);
			end
			if size(boxes,2)>1
				for bi=1:redovi_za_boxes
					C(nval+bi,j) = csum( ( (D>=str2num(boxes((bi-1)*4+2))) & (D<=str2num(boxes((bi-1)*4+4)))) .* W );
				end
			end
			if optmean + optsd + optmedian
				indx = find(D ~= NaN & D <= brkat & D >= 0);
				Ds = D(indx);
				if Ds ~= []
					if optmean
						MSD(1,j) = cmean(rsum(Ds),W(indx));
					end
					if optsd | optsigc
						MSD(2,j) = csd(rsum(Ds), W(indx));
					end
					if optmedian
						MSD(3, j) = percentile(rsum(Ds), 50,  W(indx));
					end
					
				end
			end
			if optnps
				indx = find(D ~= NaN & D <= 10 & D >= 0);
				NPS(1, j) = sum(W(indx));
				Ds = D(indx);
				Wind = W(indx);
				npsVar = make(max(size(indx)), 1, NaN);
				ind = find(Ds>=0 & Ds<=6);
					npsVar(ind) = -100;
				ind = find(Ds>=7 & Ds<=8);
					npsVar(ind) = 0;
				ind = find(Ds>=9 & Ds<=10);
					npsVar(ind) = 100;
				
				NPS(2, j) = mean(npsVar, Wind);
				NPS(3, j) = sd(npsVar, Wind);
			end
		end
		if optwhole
			ws = msum( ones(size(D,1), 1) .* W);
			N = make(size(N), ws);
		end
	else
		for j=1:nvar
			D = Data(:,vars(j));
			N(j) = csum(rsum(D~=NaN)>0);
			for i=1:nval
				C(i,j) = csum(rsum(D==val(i)));
			end
			if optsum
				C(nval+redovi_za_boxes+1,j) = csum((rsum(D<=centar1)>0));
				C(nval+redovi_za_boxes+2,j) = csum((rsum(D>=centar2 & D<=brkat)>0));
			end
			if size(boxes,2)>1
				for bi=1:redovi_za_boxes
					C(nval+bi,j) = csum( ( (D>=str2num(boxes((bi-1)*4+2))) & (D<=str2num(boxes((bi-1)*4+4)))) );
				end
			end
			if optmean+optsd
				indx = find(D ~= NaN & D <= brkat & D >= 0);
				Ds = D(indx);
				if Ds ~= []
					if optmean
						MSD(1,j) = cmean(rsum(Ds));
					end
					if optsd | optsigc
						MSD(2,j) = csd(rsum(Ds));
					end
					if optmedian
						MSD(3, j) = percentile(rsum(Ds), 50);
					end
				end
			end
			if optnps
				indx = find(D ~= NaN & D <= 10 & D >= 0);
				NPS(1, j) = max(size(indx));
				Ds = D(indx);

				npsVar = make(max(size(indx)), 1, NaN);
				ind = find(Ds>=0 & Ds<=6);
					npsVar(ind) = -100;
				ind = find(Ds>=7 & Ds<=8);
					npsVar(ind) = 0;
				ind = find(Ds>=9 & Ds<=10);
					npsVar(ind) = 100;
				
				NPS(2, j) = mean(npsVar);
				NPS(3, j) = sd(npsVar);
			end
		end
		if optwhole
			N = make(size(N), size(D,1));
		end
	end
	
	iskljuciFilterTBF;

	if def(missing)
		SetMissVal(varss, missT, missS)
	end

	for i=1:nval
		L = GetNumLabel(GetVarName(vars),val(i));
		flab = find(strlen(L));
		if flab~=[]
			RC(i) = L(flab(1));
		else
			RC(i) = num2str("%0.2f",val(i));
		end
	end
	CC = GetVarLabel(vars);
	flab = find(~strlen(CC));
	if flab~=[]
		CC(flab) = vars(flab);
	end

	%correspodence
	if optca
		[caR,caC] = crspd(C);
		caR = num2str("%0.3f",caR);
		caC = num2str("%0.3f",caC);
		print([caR(:,1),RC,caR(:,2),make(size(RC),"");
		       caC(:,1),CC',make(size(CC'),""),caC(:,2)],[],[])
		print("")
	end

	if optsum
		RC = [RC;"Sum -";"Sum +"];
	end



	Teo = rsum(C(1:size(C,1),:));
	NTeo = rsum(N);
	if opttot
		CC = ["Total",CC];
		N = [NTeo,N];
		C = [Teo,C];
	end

	%Teo = Teo/csum(Teo(1:nval));
	Teo = Teo/NTeo;
	Teo = Teo*N;
	Res = (C(1:size(C,1),:)-Teo)./sqrt(Teo);
	flab = find(Teo<5);
	if flab~=[]
		Res(flab)=0;
	end
	
	BojaFC = make(size(C),NaN);      %Boja Fonta za tabelu
	BojaBC = make(size(C),NaN);      %Boja Fonta za celiju
	%[boja pozadine, boja fonta;]

	% color=3;
% 
	if color>0
		indx = find(Res>2.58);
		if indx~=[];BojaBC(indx) = plava(1,1);BojaFC(indx) = plava(1,2);end;
		if color>1
			indx = find(Res<=2.58 & Res>1.96);
			if indx~=[];BojaBC(indx) = plava(2,1);BojaFC(indx) = plava(2,2);end;
			if color>2
				indx = find(Res<=1.96 & Res>1.64);
				if indx~=[];BojaBC(indx) = plava(3,1);BojaFC(indx) = plava(3,2);end;
			end
		end
	end

	if color>0
		indx = find(Res<-2.58);
		if indx~=[];BojaBC(indx) = crvena(1,1);BojaFC(indx) = crvena(1,2);end;
		if color>1
			indx = find(Res>=-2.58 & Res<-1.96);
			if indx~=[];BojaBC(indx) = crvena(2,1);BojaFC(indx) = crvena(2,2);end;
			if color>2
				indx = find(Res>=-1.96 & Res<-1.64);
				if indx~=[];BojaBC(indx) = crvena(3,1);BojaFC(indx) = crvena(3,2);end;
			end
		end
	end

	%Num je string za numerus (N u tabeli), a CS je string verzija C
	Num = num2str("%0.0f",N);
	if opttot
		Num(1)="";
	end
    Count = C;
	if optcount
		CS = num2str("%0.0f",C);
	else
		C = C./N * 100;  %U C su sada kolonski procenti
		strfor = "%0." + num2str("%0.0f", decimal(2)) + "f";
		CS(:,1:size(C,2)) = num2str(strfor,C(:,1:size(C,2)));
		strfor = "%0." + num2str("%0.0f", decimal(1)) + "f";
		CS(:,1) = num2str(strfor,C(:,1));
	end
    
    if optsigc
        nc = size(C,2);
        Alph = ["A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"];
        smAlph = lcase(Alph);
        for i1=1:size(C,1)
            n = Count(i1,:);
            P = n./N;
            
            ord = make(1,nc,(1:nc));
            tCOLCMP = make(size(ord),"");
            
            
            Pt = (make(nc,1, n)+make(1,nc, n'))./(make(nc,1, N)+make(1,nc, N'));
            S = sqrt(Pt.*(1-Pt).*(1./make(nc,1, N) + 1./make(1,nc, N')));
            Z = (make(nc,1, P) - make(1,nc, P')) ./ S;
            p = 2*normcdf(-abs(Z));
            
            indx = find(Z<0);
            if indx~=[]
                p(indx) = 1;
            end
            
            indx = find(P==0 | P==1);
            if indx~=[]
                p(indx,:) = 1;
                p(:,indx) = 1;
            end
            
            indx = find(N < 2);
            if indx~=[]
                p(indx,:) = 1;
                p(:,indx) = 1;
            end

            if color==3
                if nobonf
                    indx = find(p< 0.10);
                else
                    indx = find(p< 0.10/(nc*(nc-1)/2));
                end
                if indx~=[]
                    tCOLCMP(indx) = "*"+smAlph(ord(indx));
                end
            end
                    
            if nobonf
                indx = find(p< 0.05);
            else
                indx = find(p< 0.05/(nc*(nc-1)/2));
            end
            if indx~=[]
                tCOLCMP(indx) = smAlph(ord(indx));
            end

            if nobonf
                indx = find(p< 0.01);
            else
                indx = find(p< 0.01/(nc*(nc-1)/2));
            end
            if indx~=[]
                tCOLCMP(indx) = Alph(ord(indx));
            end
            
            for i2=1:nc
                COLCMP(i1,i2) = implode(tCOLCMP(:,i2),"");
            end
        end
        if optmean
            % u prvom redu MSD su proseci a u drugom SD
            m = MSD(1, :);
            sd = MSD(2, :);
            n = N;


            nc = size(m, 2);

            tCMP = make(nc, nc, "");
            CMP = make(1, nc, "");
            M = row2mat(m);
            delta = M - M';
            SD = row2mat((sd.^2) .* (n - 1));
            SD = SD + SD';
            N = row2mat(n - 1);
            N = N + N';
            SP = sqrt(SD ./ N);

            Ni = row2mat(1./n);
            Ni = Ni + Ni';

            t = delta ./ (SP .* sqrt(Ni));
            p = 2 * tcdf(-abs(t), N);
            ind = find(t < 0);
            p(ind) = 1;

            if color==3
                if nobonf
                    indx = find(p< 0.10);
                else
                    indx = find(p< 0.10/(nc*(nc-1)/2));
                end
                if indx~=[]
                    tCMP(indx) = "*"+smAlph(ord(indx));
                end
            end
                    
            if nobonf
                indx = find(p< 0.05);
            else
                indx = find(p< 0.05/(nc*(nc-1)/2));
            end
            if indx~=[]
                tCMP(indx) = smAlph(ord(indx));
            end

            if nobonf
                indx = find(p< 0.01);
            else
                indx = find(p< 0.01/(nc*(nc-1)/2));
            end
            if indx~=[]
                tCMP(indx) = Alph(ord(indx));
            end
            
            for i2=1:nc
                CMP(i2) = implode(tCMP(:,i2),"");
            end
        end
		if optnps
            % u prvom redu MSD su proseci a u drugom SD
            n = NPS(1,:);
            m = NPS(2,:);
            sd = NPS(3,:);


            nc = size(m, 2);

            tCMP = make(nc, nc, "");
            NPSCMP = make(1, nc, "");
            M = row2mat(m);
            delta = M - M';
            SD = row2mat((sd.^2) .* (n - 1));
            SD = SD + SD';
            N = row2mat(n - 1);
            N = N + N';
            SP = sqrt(SD ./ N);

            Ni = row2mat(1./n);
            Ni = Ni + Ni';

            t = delta ./ (SP .* sqrt(Ni));
			ind = find(t==NaN);
			t(ind) = 0;
            p = 2 * tcdf(-abs(t), N);
            ind = find(t < 0);
            p(ind) = 1;

            if color==3
                if nobonf
                    indx = find(p< 0.10);
                else
                    indx = find(p< 0.10/(nc*(nc-1)/2));
                end
                if indx~=[]
                    tCMP(indx) = "*"+smAlph(ord(indx));
                end
            end
                    
            if nobonf
                indx = find(p< 0.05);
            else
                indx = find(p< 0.05/(nc*(nc-1)/2));
            end
            if indx~=[]
                tCMP(indx) = smAlph(ord(indx));
            end

            if nobonf
                indx = find(p< 0.01);
            else
                indx = find(p< 0.01/(nc*(nc-1)/2));
            end
            if indx~=[]
                tCMP(indx) = Alph(ord(indx));
            end
            
            for i2=1:nc
                NPSCMP(i2) = implode(tCMP(:,i2),"");
            end
        end
    end

	indx0 = find(C==0);
	m1 = 10^decimal(1);
	C(:,1) = round(C(:,1)*m1)/m1;
	m1 = 10^decimal(2);
	C(:,1:size(C,2)) = round(C(:,1:size(C,2))*m1)/m1;

	m1 = mmax(C);
	m2 = strlen(num2str("%0.0f",m1));
	m2 = 10^m2;
	if m2>m1
		m2 = m2/10;
	end

	%kako su ovde procenti koji ne mogu biti > od 100
	if m2==100
		m2=10;
	end
	while m2>1
		indx = find(C<m2);
		if indx~=[]
			CS(indx)="#"+CS(indx);
		end
		m2 = m2/10;
	end
	if indx0~=[]
		CS(indx0)="";
	end
    
    if optsigc
        nc = size(CS,2)*2;
        cs = make(size(CS,1), nc, "");
        num = make(1, nc, "~");
        cc = make(size(CC,1), size(CC,2)*2, "~");
        
        cs(:,1:nc:2) = CS;
        cc(:,1:nc:2) = CC;
        num(1:nc:2) = Num;
        Num = num;
        
        num = make(1, nc, "~");
        num(1:nc:2) = Alph(1:nc/2);
        cs(:,2:nc:2) = COLCMP;
        CS = [num;cs];
        CC = cc;
        
        LinCol = make(1, size(CS,2), 2); %pravljenje linija
        LinCol(1:nc:2) = NaN;
    else
        LinCol = make(1, size(CS,2), 2); %pravljenje linija
    end
	

	sngl = ~any(DataIsMultiple(vars)) & ~optcount & optwhole==0;

	LinRow = make(size(CS,1)+2+sngl+optmean+optsd+optnps+optmedian,1,NaN); %Debljina linije za redove
	LinRow([1,2])=2;          %2 za debelu liniju
    if optsigc
        LinRow(3)=2;
    end
	if optsum
		LinRow(size(LinRow,1)-2-sngl-optmean-optsd-optnps)=3; %3 za duplu liniju
	end
    if optsigc
        RC=["";RC];
    end
	if sngl
		LinRow(size(LinRow,1)-1-optmean-optsd-optnps)=3; %3 za duplu liniju
		RC=["N";RC;"Total"];

		r100 = make(1, size(CS,2), "~");
		r100(1) = "100%";
		CS = [Num;CS;r100];
	else
		RC=["N";RC];
		CS = [Num;CS];
	end

	if optmean
		RC = [RC;"Mean"];
	end
	if optsd
		RC = [RC;"SD"];
	end
	if optmedian
		RC = [RC;"Median"];
	end
	if MSD~=[]
		if optmean
			mm = make(1, size(CS, 2), "");
			mm(1:size(CS, 2):(1+optsigc)) = num2str("%0.1f", MSD(1,:));
			if (optsigc)
				mm(2:size(CS, 2):2) = CMP;
			end
			CS=[CS;mm];
		end
		if optsd
			mm = make(1, size(CS, 2), "");
			mm(1:size(CS, 2):(1+optsigc)) = num2str("%0.1f", MSD(2,:));
			CS=[CS;mm];
		end
		if optmedian
			mm = make(1, size(CS, 2), "");
			mm(1:size(CS, 2):(1+optsigc)) = num2str("%0.1f", MSD(3,:));
			CS=[CS;mm];
		end

	end
	if optnps
		RC = [RC;"NPS"];
		mm = make(1, size(CS, 2), "");
        mm(1:size(CS, 2):(1+optsigc)) = num2str("%0.1f", NPS(2,:));
        if (optsigc)
			mm(2:size(CS, 2):2) = NPSCMP;
		end
		CS=[CS;mm];
	end

	LinCol = [make(1,size(RC,2),NaN), 2, LinCol];
	LinRow = [make(size(CC,1),1,NaN); LinRow];
	LinRow(2,:) = 1;

	BojaF = make(size(CS)+[size(CC,1),1],NaN); %ovo je glupost, sizeL2 je uvek 1, inace nece da radi
	BojaB = BojaF;


	BojaB(size(CC,1)+1,:) = LBColor(2); %Svetlije plavo
	BojaF(size(CC,1)+1,:) = LFColor(2); %Svetlije plavo
	if sngl
		BojaB([1,size(BojaB,1)-optmean-optsd-optmedian-optnps],:) = LBColor(3); %Tamnije plavo
		BojaF([1,size(BojaB,1)-optmean-optsd-optmedian-optnps],:) = LFColor(3); %Tamnije plavo
	else
		BojaB(1,:) = LBColor(3); %Tamnije plavo
		BojaF(1,:) = LFColor(3); %Tamnije plavo
	end
	BojaB(size(CC,1)+2+optsigc:size(BojaB,1)-sngl-optmean-optsd-optmedian-optnps, 1+1:size(BojaB,2):(1+optsigc)) = BojaBC;
	BojaF(size(CC,1)+2+optsigc:size(BojaB,1)-sngl-optmean-optsd-optmedian-optnps, 1+1:size(BojaB,2):(1+optsigc)) = BojaFC;

    if labVar~=""
        heading(3,labVar)
    end

	if any(~strcmp(layout,"ROW"))
		flab=find(~strcmp(CS,"~"));
        CS(flab)="|";
        flab=find(~strcmp(CC,"~"));
		CC(flab)="|";
		print(CS',CC',RC',BojaF',BojaB',LinCol',LinRow');
	else
		print(CS,RC,CC,BojaF,BojaB,LinRow,LinCol);
	end


	global g_footer;
	if def(footer)
		foot = footer(1);
		for i=2:max(size(footer))
			foot = foot+" "+footer(i);
		end
	elseif size(g_footer,1)
		foot = g_footer;
	else
		foot = "";
	end
	if foot~=""
		echo(foot);
	end

	print("\n")
	
end

function M = row2mat(x);
	one = size(x, 2);
	one = make(one, 1, 1);
	M = one * x;
end


function [R,C]=crspd(a);
	a = a/msum(a);
	dc=diag(csum(a));
	dr=diag(rsum(a));
	A = a - rsum(a)*csum(a);
	A = sqrt(inv(dr)) * A * sqrt(inv(dc));
	if size(A,1)<size(A,2)
		[l,s,d]=svd(A');
		N = inv(sqrt(dc))*l;
		M = inv(sqrt(dr))*d;
	else
		[l,s,d]=svd(A);
		N = inv(sqrt(dr))*l;
		M = inv(sqrt(dc))*d;
	end


	F = N * sqrt(s);
	G = M * sqrt(s);
	if size(A,1)<size(A,2)
		R = G(:,1:2);
		C = F(:,1:2);
	else
		R = F(:,1:2);
		C = G(:,1:2);
	end

end

macro ukljuciFilterTBF
	if strlen(filter(1))
		if strlen(filter_name)
			filter_old = filter_name;
			DataSelect();
			k = 0;
			repeat
				k = k+1;
				filter_new = "FILT" + num2str("%d",k);
			until (~vext(filter_new))
			DataAddVar(filter_new);
			deleteFil = 1;
			if SEL == []
				Data(:,filter_new) = Data(:,filter_old) & Data(:,filter(1));
			else
				Data(:,filter_new) = Data(:,filter_old) & Data(:,filter(1)) & SEL;
			end
			DataSelect(filter_new);
		else
			filter_old = "";
			filter_new = filter(1);
			deleteFil = 0;
			if SEL ~= []
				Data(:,filter_new) = Data(:,filter(1)) & SEL;
			end
			DataSelect(filter_new);
		end
	elseif SEL~=[]
		if strlen(filter_name)
			filter_old = filter_name;
		else
			filter_old = "";
		end
		DataSelect();
		k = 0;
		repeat
			k = k+1;
			filter_new = "FILT" + num2str("%d",k);
		until (~vext(filter_new))
		DataAddVar(filter_new);
		deleteFil = 1;
		if strlen(filter_name)
			Data(:,filter_new) = Data(:,filter_old) & SEL;
		else
			Data(:,filter_new) = SEL;
		end
		DataSelect(filter_new);
	end
end

macro iskljuciFilterTBF
	if strlen(filter(1)) | SEL ~= []
		DataSelect(filter_old);
		if deleteFil
			DataDelVar(filter_new);
		end
	end
end

function tbfMiss(M', setInd, RFDK)
% M je Mx3 matrica sa vrednostima za missing
% setInd je 0/1 da li se vrednost setuje ili iskljucuje
% RFDK je vrednost
	indx = find(M(:,3)==RFDK);
	if any(indx)
		M(indx,3)=NaN;
	end
	indx = find(M(:,2)==RFDK);
	if any(indx)
		M(indx,2)=M(indx,3);
		M(indx,3)=NaN;
	end
	indx = find(M(:,1)==RFDK);
	if any(indx)
		M(indx,1:2)=M(indx,2:3);
		M(indx,3)=NaN;
	end
	if setInd
		indx = find(M(:,3)==NaN & M(:,1)~=NaN & M(:,2)~=NaN);
		if any(indx)
			M(indx,3)=RFDK;
		end
		indx = find(M(:,2)==NaN & M(:,1)~=NaN);
		if any(indx)
			M(indx,2)=RFDK;
		end
		indx = find(M(:,1)==NaN);
		if any(indx)
			M(indx,1)=RFDK;
		end
	end
end